// DiskInfoAplet.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "DiskInfoAplet.h"
#include "cpl.h" 
#include "DialogClass.h" 

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//
//TODO: If this DLL is dynamically linked against the MFC DLLs,
//		any functions exported from this DLL which call into
//		MFC must have the AFX_MANAGE_STATE macro added at the
//		very beginning of the function.
//
//		For example:
//
//		extern "C" BOOL PASCAL EXPORT ExportedFunction()
//		{
//			AFX_MANAGE_STATE(AfxGetStaticModuleState());
//			// normal function body here
//		}
//
//		It is very important that this macro appear in each
//		function, prior to any calls into MFC.  This means that
//		it must appear as the first statement within the 
//		function, even before any object variable declarations
//		as their constructors may generate calls into the MFC
//		DLL.
//
//		Please see MFC Technical Notes 33 and 58 for additional
//		details.
//

// CDiskInfoApletApp

BEGIN_MESSAGE_MAP(CDiskInfoApletApp, CWinApp)
END_MESSAGE_MAP()


CDiskInfoApletApp * CDiskInfoApletApp::m_pThis = NULL;

// CDiskInfoApletApp construction
CDiskInfoApletApp::CDiskInfoApletApp()
{
	m_pThis = this;
}


// The one and only CDiskInfoApletApp object

CDiskInfoApletApp theApp;


// CDiskInfoApletApp initialization

BOOL CDiskInfoApletApp::InitInstance()
{
	CWinApp::InitInstance();

	return TRUE;
}

LONG APIENTRY CDiskInfoApletApp::CPlApplet(HWND hWnd, UINT uMsg,
 LONG lParam1, LONG lParam2)
{

 AFX_MANAGE_STATE(AfxGetStaticModuleState());

 CDiskInfoApletApp* pAplet = m_pThis;
 ASSERT(pAplet);

 switch (uMsg)
 {
  case CPL_DBLCLK:
  return pAplet->OnDblclk(hWnd, lParam1, lParam2);

  case CPL_EXIT:
  return pAplet->OnExit();

  case CPL_GETCOUNT:
  return pAplet->OnGetCount();

  case CPL_INIT:
  return pAplet->OnInit();

  case CPL_INQUIRE:
  return pAplet->OnInquire(lParam1, (CPLINFO*)lParam2);

  case CPL_NEWINQUIRE:
  return pAplet->OnNewInquire(lParam1,
   (NEWCPLINFO*)lParam2);

  case CPL_STOP:
  return pAplet->OnStop(lParam1, lParam2);

  case CPL_STARTWPARMS:
  return pAplet->OnDblclk(hWnd, lParam1, lParam2);

  default:
  break;
 }

 return 1;
}


LONG CDiskInfoApletApp::OnNewInquire(UINT uAppNum,
 NEWCPLINFO* pInfo)
{
 pInfo->dwSize		  = sizeof(NEWCPLINFO);
 pInfo->dwFlags		  = 0;
 pInfo->dwHelpContext = 0;
 pInfo->lData		  = 0;
 pInfo->hIcon		  = LoadIcon(IDI_ICON1);


 CString sCplName, sCplInfo;
 sCplName.LoadString(IDS_STRINGNAME);
 sCplInfo.LoadString(IDS_STRINGINFO);

 _tcscpy(pInfo->szName, sCplName);
 _tcscpy(pInfo->szInfo, sCplInfo);
 _tcscpy(pInfo->szHelpFile, _T(""));

 return 0;
}

LONG CDiskInfoApletApp::OnInquire(UINT uAppNum, CPLINFO* pInfo)
{
	pInfo->idIcon	= IDI_ICON1;
	pInfo->idName	= IDS_STRINGNAME;
	pInfo->idInfo	= IDS_STRINGINFO;
	pInfo->lData	= 0;
	

 return 0;
}

LONG CDiskInfoApletApp::OnDblclk(HWND hWnd, UINT uAppNum,
 LONG lData)
{	
	dialog.DoModal();
	return 0;
}

LONG CDiskInfoApletApp::OnExit()
{
 return 0; 
}

LONG CDiskInfoApletApp::OnGetCount()
{
 return 1; 
}

LONG CDiskInfoApletApp::OnInit()
{
 return 1; 
}

LONG CDiskInfoApletApp::OnStop(UINT uAppNum, LONG lData)
{
 return 1; 
}