// //////////////////////////////////////////
/*
FTP List parse Module
version 0.1.1
http://www.slavon.net
ftp_parse_module@slavon.net
Copyright (C) 2004  Badalian Slava

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
// //////////////////////////////////////////

// SUPORTED LIST FORMATS:

/* UNIX-style listing, without inum and without blocks */                                                                
/* "-rw-r--r--   1 root     other        531 Jan 29 03:26 README" */                                                     
/* "dr-xr-xr-x   2 root     other        512 Apr  8  1994 etc" */                                                        
/* "dr-xr-xr-x   2 root     512 Apr  8  1994 etc" */                                                                     
/* "lrwxrwxrwx   1 root     other          7 Jan 25 00:17 bin -> usr/bin" */                                             

/* Also produced by Microsoft's FTP servers for Windows: */                                                              
/* "----------   1 owner    group         1803128 Jul 10 10:18 ls-lR.Z" */                                               
/* "d---------   1 owner    group               0 May  9 19:45 Softlib" */                                               

/* Also WFTPD for MSDOS: */                                                                                              
/* "-rwxrwxrwx   1 noone    nogroup      322 Aug 19  1996 message.ftp" */                                                

/* Also NetWare: */                                                                                                      
/* "d [R----F--] supervisor            512       Jan 16 18:53    login" */                                               
/* "- [R----F--] rhesus             214059       Oct 20 15:27    cx.exe" */                                              

/* Also NetPresenz for the Mac: */                                                                                       
/* "-------r--         326  1391972  1392298 Nov 22  1995 MegaPhone.sit" */                                              
/* "drwxrwxr-x               folder        2 May 10  1996 network" */


/* MultiNet (some spaces removed from examples) */                                                                         
/* "00README.TXT;1      2 30-DEC-1996 17:44 [SYSTEM] (RWED,RWED,RE,RE)" */                                                 
/* "CORE.DIR;1          1  8-SEP-1996 16:09 [SYSTEM] (RWE,RWE,RE,RE)" */                                                   
/* and non-MutliNet VMS: */                                                                                                
/* "CII-MANUAL.TEX;1  213/216  29-JAN-1996 03:33:12  [ANONYMOU,ANONYMOUS]   (RWED,RWED,,)" */ 


/* MSDOS format */                                                                                                         
/* 04-27-00  09:09PM       <DIR>          licensed */                                                                      
/* 07-18-00  10:16AM       <DIR>          pub */                                                                           
/* 04-14-00  03:47PM                  589 readme.htm */ 

//  SORRY! TIME IS NOT PARSING NOW :(

#define P_NUM 10

#include "ftpparse2.h"

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <pcreposix.h>


struct patterns {
        char *pattern;
};


int list_parse(const char *, struct ftplist *);
void set_type(int *, const char);

int list_parse(const char *buf,  struct ftplist * ret){
    regmatch_t p[20]; 
    regex_t f; 
    int j,i,k,zx;
    char filed[20][MAX_FILE_LEN];

    struct patterns pat[P_NUM-1];
    pat[0].pattern="^(d|l|-)\\S{9}\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\w{3})\\s+(\\d{1,2})\\s+(\\d{4})\\s+(.+?)(\\s+\\-\\>\\s+.+)?$";
    pat[1].pattern="^(d|l|-)\\S{9}\\s+\\d+\\s+\\S+\\s+\\S+\\s+(\\d+)\\s+(\\w{3})\\s+(\\d{1,2})\\s+(\\d{1,2}):(\\d{1,2})\\s+(.+?)(\\s+\\-\\>\\s+.+)?$";
    pat[2].pattern="^(d|l|-)\\S{9}\\s+\\d+\\s+\\S+\\s+\\S+\\s+(\\d+)\\s+(\\w{3})\\s+(\\d{1,2})\\s+(\\d{4})\\s+(.+?)(\\s+\\-\\>\\s+.+)?$";
    pat[3].pattern="^(d|l|-)\\S{9}\\s+\\d+\\s+\\S+\\s+(\\d+)\\s+(\\w{3})\\s+(\\d{1,2})\\s+(\\d{4})\\s+(.+?)(\\s+\\-\\>\\s+.+)?$";
    pat[4].pattern="^(d|-)\\s+\\[\\S{8}\\]\\s+\\S+\\s+(\\d+)\\s+(\\w{3})\\s+(\\d{1,2})\\s+(\\d{1,2}):(\\d{1,2})\\s+(.+)$";
    pat[5].pattern="^(d|l|-)\\S{9}\\s+folder\\s+(\\d+)\\s+(\\w{3})\\s+(\\d{1,2})\\s+(\\d{4})\\s+(.+?)(\\s+\\-\\>\\s+.+)?$";
    pat[6].pattern="^(.+?)\\;\\d+\\s+(\\d+)\\s+\\d{1,2}\\-\\w{3}\\-\\d{1,4}\\s+\\d{1,2}:\\d{1,2}\\s+\\[\\S+\\]\\s+\\([RWED,]+\\)$";
    pat[7].pattern="^(.+?)\\;\\d+\\s+\\d+\\/\\d+\\s+\\d{1,2}\\-\\w{3}\\-\\d{1,4}\\s+\\d{1,2}:\\d{1,2}:\\d{1,2}\\s+\\[\\S+\\]\\s+\\([RWED,]+\\)$";
    pat[8].pattern="^\\d{1,2}\\-\\d{1,2}\\-\\d{1,4}\\s+\\d{1,2}:\\d{1,2}[APM]{2}\\s+(\\d+)\\s+(.+?)$";
    pat[9].pattern="^\\d{1,2}\\-\\d{1,2}\\-\\d{1,4}\\s+\\d{1,2}:\\d{1,2}[APM]{2}\\s+\\<DIR\\>\\s+(.+?)$";
    int pat_i[P_NUM-1];
    pat_i[0] = 8;
    pat_i[1] = 7;
    pat_i[2] = 6;
    pat_i[3] = 6;
    pat_i[4] = 7;
    pat_i[5] = 6;
    pat_i[6] = 2;
    pat_i[7] = 1;
    pat_i[8] = 2;
    pat_i[9] = 1;
	    
    for(i=0; i<P_NUM; i++){
        if(regcomp(&f,pat[i].pattern,0)) 
    	{
	    printf("LIST PARSING MODULE: REGEXP::error in templite!\n");
	    regfree(&f);
	    return -1;
	}
    	if(regexec(&f,buf,20,p,0)) {
	    regfree(&f);
	    continue;
	}
	for(zx=1; zx<=pat_i[i]; zx++){
	    k=0;
	    for(j=p[zx].rm_so;j<p[zx].rm_eo;j++){ 
	    	filed[zx][k] = buf[j];
		k++;
    	    }
	    filed[zx][k] = '\0';
	}
   	regfree(&f);
        break;
	}
//	printf("==%d==\n",i);
	switch(i){
		case 0:
			strcpy(ret->name, (char *)&filed[8]);
			//IT'S SIZE??? :) or size is filed[3] or filed[4]
			ret->size = atoi(filed[2]);
			set_type(&ret->type, filed[1][0]);
			return 1;
			break;
		case 1:
			strcpy(ret->name, (char *)&filed[7]);
			ret->size = atoi(filed[2]);
			set_type(&ret->type, filed[1][0]);
			return 1;
			break;
		case 2:
			strcpy(ret->name, (char *)&filed[6]);
			ret->size = atoi(filed[2]);
			set_type(&ret->type, filed[1][0]);
			return 1;
			break;
		case 3:
			strcpy(ret->name, (char *)&filed[6]);
			ret->size = atoi(filed[2]);
			set_type(&ret->type, filed[1][0]);
			return 1;
			break;
		case 4:
			strcpy(ret->name, (char *)&filed[7]);
			ret->size = atoi(filed[2]);
			set_type(&ret->type, filed[1][0]);
			return 1;
			break;
		case 5:
			strcpy(ret->name, (char *)&filed[6]);
			ret->size = atoi(filed[2]);
			set_type(&ret->type, filed[1][0]);
			return 1;
			break;
		case 6:
			strcpy(ret->name, (char *)&filed[1]);
			//IT'S SIZE??? :)
			ret->size = atoi(filed[2]);
			ret->type = P_UNKNOWN;
			return 1;
			break;
		case 7:
			strcpy(ret->name, (char *)&filed[1]);
			//what filed is size??
			ret->size = -1;
			ret->type = P_UNKNOWN;
			return 1;
			break;
		case 8:
			strcpy(ret->name, (char *)&filed[2]);
			ret->size = atoi(filed[1]);
			ret->type = P_FILE;
			return 1;
			break;
		case 9:
			strcpy(ret->name, (char *)&filed[1]);
			ret->size = -1;
			ret->type = P_DIR;
			return 1;
			break;

		case P_NUM:
			printf("LIST PARSING MODULE: no found %s\n", buf);
			return -1;
			break;
	}
	printf("LIST PARSING MODULE: Unknown ERROR\n");
	return -1;

return 0;
}

void set_type(int * type, const char buf){
	if(buf == 'd')
		*type = P_DIR;
	else if(buf == 'l')
		*type = P_LINK;
	else if(buf == '-')
		*type = P_FILE;
	else
		*type = P_UNKNOWN;

	return;
}
