﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Threading.Tasks

Module Module1

    Private Function obliczenia(argument As Double) As Double
        For i As Integer = 0 To 9
            argument = Math.Asin(Math.Sin(argument))
        Next
        Return argument
    End Function

    Private Sub uruchomObliczenia()
        'przygotowania 
        Dim rozmiar As Integer = 10000
        Dim r As Random = New Random()
        Dim tablica(rozmiar) As Double
        For i As Integer = 0 To tablica.Length - 1
            tablica(i) = r.NextDouble()
        Next

        'obliczenia sekwencyjne
        Dim iloscPowtorzen As Integer = 100
        Dim wyniki(tablica.Length) As Double
        Dim start As Integer = System.Environment.TickCount
        For powtorzenia As Integer = 0 To iloscPowtorzen - 1
            For i As Integer = 0 To tablica.Length - 1
                wyniki(i) = obliczenia(tablica(i))
            Next
        Next
        Dim [stop] As Integer = System.Environment.TickCount
        Console.WriteLine("Obliczenia sekwencyjne trwały " & ([stop] - start).ToString() & " ms.")

        'obliczenia równoległe
        start = System.Environment.TickCount
        For powtorzenia As Integer = 0 To iloscPowtorzen - 1
            Parallel.For(0, tablica.Length, Function(i As Integer) wyniki(i) = obliczenia(tablica(i)))
        Next
        [stop] = System.Environment.TickCount
        Console.WriteLine("Obliczenia równoległe trwały " & ([stop] - start).ToString() & " ms.")

        'prezentacja wyników 
        'Dim s As String = "Wyniki:" & vbNewLine
        'For i As Integer = 0 To tablica.Length - 1
        '    s &= i & ". " & tablica(i) & " ?= " & wyniki(i) & vbNewLine
        'Next
        'Console.WriteLine(s)
    End Sub

    Private Sub przerywaniePetli()
        Dim r As Random = New Random()
        Dim suma As Long = 0
        Dim licznik As Long = 0
        Dim s As String = ""

        'iteracje zostana wykonane tylko dla liczb parzystych
        'petla zostanie przerwana wcześniej, jeżeli wylosowana liczba jest większa od 90
        Parallel.For(0, 10000, Sub(i As Integer, stanPetli As ParallelLoopState)
                                   Dim liczba As Integer = r.Next(7) 'losowanie liczby oczek na kostce
                                   If liczba = 0 Then
                                       s &= "Stop:"
                                       stanPetli.Stop()
                                   End If
                                   If stanPetli.IsStopped Then Return
                                   If liczba Mod 2 = 0 Then
                                       s &= liczba.ToString() & "; "
                                       obliczenia(liczba)
                                       suma += liczba
                                       licznik += 1
                                   Else
                                       s &= liczba.ToString() & "; "
                                   End If
                               End Sub)

        Console.WriteLine( _
           "Wylosowane liczby: " & s & vbNewLine & _
           "Liczba pasujących liczb: " & licznik & vbNewLine & _
           "Suma: " & suma & vbNewLine & _
           "Średnia: " & (suma / CDbl(licznik)).ToString())
    End Sub

    Sub Main()
        Console.WriteLine("1. Równoległa pętla For")
        uruchomObliczenia()

        Console.WriteLine(vbNewLine & "2. Przerywanie petli")
        przerywaniePetli()
    End Sub

End Module
