﻿Option Strict On
Option Explicit On
Option Infer Off

Imports System.Xml

Public Class Form1
    Private plikUstawien As String = "Ustawienia.xml"

    Private Sub Form1_FormClosed(sender As System.Object, e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        Dim xml As XmlTextWriter = Nothing
        Try
            'tworzenie pliku
            xml = New XmlTextWriter(plikUstawien, System.Text.Encoding.UTF8)
            xml.Formatting = Formatting.Indented
            xml.WriteStartDocument(True) 'wersja XML itp.

            xml.WriteComment("Parametry aplikacji") 'komentarz

            '<opcje>>
            xml.WriteStartElement("opcje")

            '<okno nazwa=Form1>
            xml.WriteStartElement("okno")
            xml.WriteAttributeString("nazwa", Me.Text)
            '<pozycja>
            xml.WriteStartElement("pozycja")
            xml.WriteElementString("X", Me.Left.ToString())
            xml.WriteElementString("Y", Me.Top.ToString())
            xml.WriteEndElement()
            '</pozycja>
            '<wielkość>
            xml.WriteStartElement("wielkość")
            xml.WriteElementString("Szer", Me.Width.ToString())
            xml.WriteElementString("Wys", Me.Height.ToString())
            xml.WriteEndElement()
            '</wielkość>
            xml.WriteEndElement()
            '</okno>

            xml.WriteEndElement()
            '</opcje>

            xml.WriteEndDocument() 'koniec dokumentu
        Catch exc As Exception
            MessageBox.Show("Błąd w zapisywaniu ustawień do pliku (" & exc.Message & ")")
        Finally
            xml.Close()
        End Try
    End Sub

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Dim xml As XmlTextReader = Nothing
        Try
            xml = New XmlTextReader(plikUstawien)

            '<opcje>>
            xml.ReadStartElement("opcje")

            '<okno nazwa=Form1>
            xml.Read()
            Me.Text = xml("nazwa")
            xml.ReadStartElement("okno")
            '<pozycja>
            xml.ReadStartElement("pozycja")
            Me.Left = Int32.Parse(xml.ReadElementString("X"))
            Me.Top = Int32.Parse(xml.ReadElementString("Y"))
            xml.ReadEndElement()
            '</pozycja>
            '<wielkość>
            xml.ReadStartElement("wielkość")
            Me.Width = Int32.Parse(xml.ReadElementString("Szer"))
            Me.Height = Int32.Parse(xml.ReadElementString("Wys"))
            xml.ReadEndElement()
            '</wielkość>
            xml.ReadEndElement()
            '</okno>

            xml.ReadEndElement()
            '</opcje>
        Catch exc As Exception
            MessageBox.Show("Błąd w odczytywaniu ustawień z pliku (" & exc.Message & ")")
        Finally
            xml.Close()
        End Try
    End Sub

    Private Shared Function AnalizaPlikuXML(plikXML As String) As String
        If Not System.IO.File.Exists(plikXML) Then _
            Throw New Exception("Pliku " & plikXML & " nie istnieje")

        Dim xml As XmlReader = Nothing
        Dim ustawienia As XmlReaderSettings = New XmlReaderSettings()
        ustawienia.IgnoreWhitespace = True
        ustawienia.IgnoreProcessingInstructions = True

        Dim s As String = ""

        Try
            xml = XmlReader.Create(plikXML, ustawienia)

            While xml.Read()
                s &= "(" & xml.Depth & ")" & vbTab
                Select Case xml.NodeType
                    Case XmlNodeType.XmlDeclaration
                        s &= "Deklaracja: " & xml.Value
                    Case XmlNodeType.Comment
                        s &= "Komentarz: " & xml.Value
                    Case XmlNodeType.Element
                        s &= "Element: " & xml.Name
                        If xml.HasAttributes Then
                            s &= ", atrybuty: "
                            For i As Integer = 0 To xml.AttributeCount - 1
                                xml.MoveToAttribute(i)
                                s &= xml.Name & "=" & xml.QuoteChar & xml.Value & xml.QuoteChar & " "
                            Next
                        End If
                    Case XmlNodeType.EndElement
                        s &= "Zakończenie elementu: " & xml.Name
                    Case XmlNodeType.Text
                        s &= "Tekst: " & xml.Value
                End Select
                s &= vbNewLine
            End While
        Catch exc As Exception
            Throw New Exception("Błąd podczas czytania danych z pliku (" & exc.Message & ")")
        Finally
            xml.Close()
        End Try

        Return s
    End Function

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        MessageBox.Show(AnalizaPlikuXML(plikUstawien))
    End Sub
End Class
