﻿'Option Strict On
'Option Explicit On
'Option Infer Off

Imports System.IO

Public Class Form1

    Public Shared Function CzytajPlikTekstowy(nazwaPliku As String) As String()
        Dim tekst As New List(Of String)
        Try
            Using sr As StreamReader = New StreamReader(nazwaPliku)
                Dim wiersz As String = sr.ReadLine()
                While wiersz IsNot Nothing
                    tekst.Add(wiersz)
                    wiersz = sr.ReadLine()
                End While
            End Using
            Return tekst.ToArray()
        Catch e As Exception
            MessageBox.Show("Błąd odczytu pliku " & nazwaPliku & " (" & e.Message & ")")
            Return Nothing
        End Try
    End Function

    Private Sub FileListBox1_DwukrotneKliknieciePliku(sender As System.Object, e As System.EventArgs, nazwaPliku As System.String) Handles FileListBox1.DwukrotneKliknieciePliku        
        TextBox1.Lines = CzytajPlikTekstowy(nazwaPliku)
    End Sub

    Private Sub FileListBox1_MouseDown(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles FileListBox1.MouseDown
        Dim ścieżkaPliku As String = FileListBox1.ŚcieżkaDoZaznaczonegoElementu
        If e.Button = MouseButtons.Left And File.Exists(ścieżkaPliku) Then
            Dim operacja As DragDropEffects = FileListBox1.DoDragDrop(ścieżkaPliku, DragDropEffects.Move)
        End If
    End Sub

    Private Sub TextBox1_DragOver(sender As System.Object, e As System.Windows.Forms.DragEventArgs) Handles TextBox1.DragOver
        e.Effect = DragDropEffects.Move
    End Sub

    Private Sub TextBox1_DragDrop(sender As System.Object, e As System.Windows.Forms.DragEventArgs) Handles TextBox1.DragDrop
        TextBox1.Lines = CzytajPlikTekstowy(e.Data.GetData(DataFormats.Text).ToString())
    End Sub
End Class
