﻿Option Strict On
Option Explicit On
Option Infer Off

Imports System.Diagnostics

Public Class Form1

    Public Sub New()

        ' This call is required by the designer.
        InitializeComponent()

        Try
            'Tytuł okna
            Text = "Lista procesów na " & System.Environment.MachineName

            'Pobieranie i wyświetlanie listy uruchomionych procesów
            Dim procesy As Process() = Process.GetProcesses()
            For Each proces As Process In procesy
                If proces.Id = 0 Then Continue For 'Proces bezczynności systemu
                Dim opis As String = proces.Id.ToString() & vbTab & proces.BasePriority.ToString() & vbTab & proces.StartTime.ToString() & vbTab & proces.TotalProcessorTime.ToString() & vbTab & proces.Threads.Count.ToString()
                Dim tytul As String = proces.MainWindowTitle
                opis &= If(tytul = "", proces.ProcessName.ToUpper(), tytul)
                ListBox1.Items.Add(opis)
            Next
        Catch ex As Exception
            MessageBox.Show("Błąd: " & ex.Message, "Procesy", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Throw ex 'obiekt okna nie powstanie
        End Try
    End Sub
End Class
