﻿Option Strict On
Option Explicit On
Option Infer Off

Imports System.Runtime.InteropServices

Public Class Form1
    <DllImport("User32.dll")>
    Private Shared Function MessageBeep(rodzajDzwieku As UInteger) As Boolean
    End Function

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        MessageBeep(0)
        MessageBeep(48)
    End Sub

    <DllImport("kernel32.dll")>
    Private Shared Function WinExec(polecenie As String, stanOkna As UInteger) As UInteger
    End Function

    Enum StyleOkna As UInteger
        Ukryte = 0
        Normalme
        Zminimalizowane
        Zmaksymalizowane
        Nieaktywne
        Domyslne = 10
    End Enum

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        Dim wynik As UInteger = WinExec(TextBox1.Text, StyleOkna.Normalme)
        If wynik <= 31 Then _
            MessageBox.Show("Błąd " & wynik & "! Nie udało się uruchomić " & TextBox1.Text)
    End Sub

    <DllImport("kernel32.dll")>
    Private Shared Function GetDiskFreeSpaceEx(
        ByVal katalog As String,
        ByRef wolneMiejsceDlaUzytkownika As Long,
        ByRef rozmiarDysku As Long,
        ByRef wolneMiejsceNaDysku As Long) As Boolean
    End Function

    Private Shared Function wolneMiejsceNaDysku(katalogGlownyDysku As String) As Integer
        Dim wolneMiejsceNaDyskuProcenty As Integer
        Dim wolneMiejsceDlaUzytkownika As Long = 0
        Dim rozmiarDysku As Long = 0
        Dim _wolneMiejsceNaDysku As Long = 0
        If GetDiskFreeSpaceEx(katalogGlownyDysku,
              wolneMiejsceDlaUzytkownika,
              rozmiarDysku,
              _wolneMiejsceNaDysku) Then
            wolneMiejsceNaDyskuProcenty = CInt(100 * (rozmiarDysku - _wolneMiejsceNaDysku) / rozmiarDysku)
        Else
            wolneMiejsceNaDyskuProcenty = -1
        End If
        Return wolneMiejsceNaDyskuProcenty
    End Function

    Public Sub New()
        InitializeComponent()

        Dim katalogGlownyDysku As String = "C:\" 'System.Environment.GetLogicalDrives()(0)
        Dim procentZajetosci As Integer = wolneMiejsceNaDysku(katalogGlownyDysku)
        If procentZajetosci >= 0 Then ProgressBar1.Value = procentZajetosci
    End Sub

    <DllImport("kernel32.dll")>
    Private Shared Function GetWindowsDirectory(bufor As System.Text.StringBuilder, rozmiarBufora As UInteger) As UInteger
    End Function

    Private Sub Button3_Click(sender As System.Object, e As System.EventArgs) Handles Button3.Click
        Const MAX_PATH As Integer = 260
        Dim katalogWindows As System.Text.StringBuilder = New System.Text.StringBuilder(MAX_PATH)
        Dim rozmiar As UInteger = CUInt(katalogWindows.Capacity)
        GetWindowsDirectory(katalogWindows, rozmiar)
        MessageBox.Show(katalogWindows.ToString())
    End Sub
End Class
