﻿Option Strict On
Option Explicit On
Option Infer On

Public Class Form1
    Dim listaOsob As List(Of Osoba) = New List(Of Osoba)({ _
        New Osoba With {.Id = 1, .Imię = "Bob", .Nazwisko = "Parr", .NumerTelefonu = 7272024, .Wiek = 39}, _
        New Osoba With {.Id = 2, .Imię = "Helena", .Nazwisko = "Parr", .NumerTelefonu = 7272025, .Wiek = 40}, _
        New Osoba With {.Id = 3, .Imię = "Wiola", .Nazwisko = "Parr", .NumerTelefonu = 7272022, .Wiek = 14}, _
        New Osoba With {.Id = 4, .Imię = "Maks", .Nazwisko = "Parr", .NumerTelefonu = 7272021, .Wiek = 11}, _
        New Osoba With {.Id = 5, .Imię = "Jack-Jack", .Nazwisko = "Parr", .NumerTelefonu = 0, .Wiek = 1} _
    })

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        'zapytania
        Dim listaOsobPelnoletnich1 = From osoba In listaOsob
                                    Where osoba.Wiek >= 18
                                    Order By osoba.Wiek
                                    Select New With {.Imię = osoba.Imię, .Nazwisko = osoba.Nazwisko, .Wiek = osoba.Wiek}

        Dim listaOsobPelnoletnich = From osoba In listaOsob
                                    Where osoba.Wiek >= 18
                                    Order By osoba.Wiek
                                    Select osoba

        Dim podlista As List(Of Osoba) = listaOsobPelnoletnich.ToList()

        'wyswietlanie danych
        Dim s As String = "Lista osób pełnoletnich:" & vbNewLine
        For Each osoba In listaOsobPelnoletnich
            s &= osoba.Imię & " " & osoba.Nazwisko & vbNewLine
        Next
        MessageBox.Show(s)

        'analiza danych
        MessageBox.Show("Wiek najstarszej osoby: " & _
                        listaOsobPelnoletnich.Max(Function(osoba) osoba.Wiek))
        MessageBox.Show("Średni wiek osób pełnoletnich: " & _
                        listaOsobPelnoletnich.Average(Function(osoba) osoba.Wiek))
        MessageBox.Show("Suma lat osób pełnoletnich: " & _
                        listaOsobPelnoletnich.Sum(Function(osoba) osoba.Wiek))

        'wybór elementu
        Dim najstarszaOsoba = listaOsobPelnoletnich.Single( _
            Function(osoba1) (osoba1.Wiek = listaOsobPelnoletnich.Max(Function(osoba) osoba.Wiek)))
        MessageBox.Show("Najstarsza osoba: " & najstarszaOsoba.Imię & " " & _
                        najstarszaOsoba.Nazwisko & " (" & najstarszaOsoba.Wiek & ")")

        'weryfikowanie danych
        Dim czyWszystkiePełnoletnie As Boolean = listaOsobPelnoletnich.All(Function(osoba) osoba.Wiek > 18)
        Dim czyZawieraPelnoletnią As Boolean = listaOsob.Any(Function(osoba) osoba.Wiek > 18)
    End Sub

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        'prezentacja w grupach
        Dim grupyOsobWZaleznosciOdWieku = From osoba In listaOsob
                                          Group osoba By klucz = osoba.Wiek > 18 Into Group
                                          Select New With {.Klucz = klucz, .Osoby = Group}

        Dim s As String = "Lista osób pogrupowanych w zależności od pełnoletności:" & vbNewLine & vbNewLine
        For Each grupa In grupyOsobWZaleznosciOdWieku
            s &= "Grupa osób " & If(grupa.Klucz, "pełnoletnich", "niepełnoletnich") & vbNewLine
            For Each osoba As Osoba In grupa.Osoby
                s &= osoba.Imię & " " & osoba.Nazwisko & vbNewLine
            Next
            s &= vbNewLine
        Next
        MessageBox.Show(s)
    End Sub

    Private Sub Button3_Click(sender As System.Object, e As System.EventArgs) Handles Button3.Click
        Dim listaOsobPelnoletnich = From osoba In listaOsob
                                    Where osoba.Wiek >= 18
                                    Order By osoba.Wiek
                                    Select osoba.Imię, osoba.Nazwisko, osoba.Wiek
        Dim listaKobiet = From osoba In listaOsob
                          Where osoba.Imię.EndsWith("a")
                          Select osoba.Imię, osoba.Nazwisko, osoba.Wiek

        'Dim listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich.Concat(listaKobiet)
        'Dim listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich.Concat(listaKobiet).Distinct()
        Dim listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich.Union(listaKobiet)

        Dim listaKobietPelnoletnich = listaOsobPelnoletnich.Intersect(listaKobiet)
        Dim listaPelnoletnichNiekobiet = listaOsobPelnoletnich.Except(listaKobiet)
    End Sub

    Private Sub Button4_Click(sender As System.Object, e As System.EventArgs) Handles Button4.Click
        Dim listaTelefonów = From osoba In listaOsob
                             Select New With {.Id = osoba.Id, .NumerTelefonu = osoba.NumerTelefonu}
        Dim listaPersonaliów = From osoba In listaOsob
                               Select New With {.Id = osoba.Id, .Imię = osoba.Imię, .Nazwisko = osoba.Nazwisko}

        Dim listaPersonaliówZTelefonami =
            From telefon In listaTelefonów
            Join personalia In listaPersonaliów
            On telefon.Id Equals personalia.Id
            Select New With
            {
                .Id = telefon.Id,
                .Imię = personalia.Imię,
                .Nazwisko = personalia.Nazwisko,
                .NumerTelefonu = telefon.NumerTelefonu
            }
    End Sub

    Private Sub Button5_Click(sender As System.Object, e As System.EventArgs) Handles Button5.Click
        'tworzenie podkolekcji
        Dim listaOsobPelnoletnich = From osoba In listaOsob
                                    Where osoba.Wiek >= 18
                                    Order By osoba.Wiek
                                    Select osoba

        'wyświetlanie oryginału
        Dim s As String = "Lista osób:" & vbNewLine
        For Each osoba In listaOsob
            s &= osoba.Imię & " " & osoba.Nazwisko & vbNewLine
        Next
        MessageBox.Show(s)

        'modyfikacja podkolekcji
        Dim pierwszyNaLiscie As Osoba = listaOsobPelnoletnich.First()
        With pierwszyNaLiscie
            .Imię = "Bud-Buddy"
            .Nazwisko = "Pine"
            .Wiek = 24
        End With

        'sprawdzanie oryginału
        s = "Lista osób po modyfikacjach:" & vbNewLine
        For Each osoba In listaOsob
            s &= osoba.Imię & " " & osoba.Nazwisko & vbNewLine
        Next
        MessageBox.Show(s)
    End Sub

    Private Sub Button6_Click(sender As System.Object, e As System.EventArgs) Handles Button6.Click
        'tworzenie podkolekcji
        Dim listaOsobPelnoletnich = From osoba In listaOsob
                                    Where osoba.Wiek >= 18
                                    Order By osoba.Wiek
                                    Select New Osoba With {.Id = osoba.Id, .Imię = osoba.Imię, .Nazwisko = osoba.Nazwisko, .NumerTelefonu = osoba.NumerTelefonu, .Wiek = osoba.Wiek}


        'wyświetlanie oryginału
        Dim s As String = "Lista osób:" & vbNewLine
        For Each osoba In listaOsob
            s &= osoba.Imię & " " & osoba.Nazwisko & vbNewLine
        Next
        MessageBox.Show(s)

        'modyfikacja podkolekcji
        Dim pierwszyNaLiscie As Osoba = listaOsobPelnoletnich.First()
        With pierwszyNaLiscie
            .Imię = "Bud-Buddy"
            .Nazwisko = "Pine"
            .Wiek = 24
        End With

        'sprawdzanie oryginału
        s = "Lista osób po modyfikacjach:" & vbNewLine
        For Each osoba In listaOsob
            s &= osoba.Imię & " " & osoba.Nazwisko & vbNewLine
        Next
        MessageBox.Show(s)
    End Sub
End Class

Class Osoba
    Public Id As Integer
    Public Imię, Nazwisko As String
    Public NumerTelefonu As Integer
    Public Wiek As Integer
End Class
