﻿Option Strict Off 'late binding w metodzie Button7_Click
Option Explicit On
Option Infer Off

Imports System.Reflection

Public Class Form1
    'Private Const nazwaPlikuDLL As String = "c:\Documents and Settings\jacek\Moje dokumenty\Visual Studio 2010\Projects\SystemInfo\SystemInfo\bin\Debug\SystemInfo.dll"
    Private nazwaPlikuDLL As String = System.IO.Path.Combine(System.Environment.CurrentDirectory, "SystemInfo.dll")

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        Try
            If Not System.IO.File.Exists(nazwaPlikuDLL) Then
                Throw New Exception("Brak pliku biblioteki DLL")
            End If
            Dim a As Assembly = Assembly.LoadFrom(nazwaPlikuDLL)
            MessageBox.Show("Wczytano podzespół:" & vbNewLine & a.FullName & vbNewLine & "z pliku " & a.Location)
        Catch exc As Exception
            MessageBox.Show("Wczytanie podzespołu z pliku " & nazwaPlikuDLL & " nie powiodło się (" & exc.Message & ").")
            Return
        End Try
    End Sub

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        Dim a As Assembly = Assembly.LoadFrom(nazwaPlikuDLL)
        Dim nazwyTypow As String = "Nazwy klas:" & vbNewLine
        Dim typy As Type() = a.GetTypes()
        For Each typ As Type In typy
            nazwyTypow &= typ.FullName & vbNewLine
        Next
        MessageBox.Show(nazwyTypow)
    End Sub

    Private Const nazwaKlasy As String = "Helion.SystemInfo"

    Private Sub Button3_Click(sender As System.Object, e As System.EventArgs) Handles Button3.Click
        Dim a As Assembly = Assembly.LoadFrom(nazwaPlikuDLL)
        Dim klasa As Type = a.GetType(nazwaKlasy)
        If klasa = Nothing Then
            MessageBox.Show("Nie znaleziono klasy " & nazwaKlasy)
        Else
            'MessageBox.Show("Znaleziono klasę " & nazwaKlasy)
            Dim nazwyMetod As String = "Sygnatury metod:" & vbNewLine
            Dim metody As MethodInfo() = klasa.GetMethods()
            For Each metoda As MethodInfo In metody
                nazwyMetod += metoda.ToString() & vbNewLine
            Next
            MessageBox.Show("Znaleziono klasę " & nazwaKlasy &
                            vbNewLine & vbNewLine & nazwyMetod)
        End If
    End Sub

    'Private Sub Button4_Click(sender As System.Object, e As System.EventArgs) Handles Button4.Click
    '    Dim nazwaMetody As String = "Show"
    '    Dim zwracanaWartoscMetody As Type = GetType(Void)

    '    Try
    '        Dim a As Assembly = Assembly.LoadFrom(nazwaPlikuDLL)
    '        Dim klasa As Type = a.GetType(nazwaKlasy)
    '        If klasa = Nothing Then _
    '            Throw New Exception("Nie znaleziono klasy " & nazwaKlasy)
    '        Dim metoda As MethodInfo = klasa.GetMethod(nazwaMetody)
    '        If metoda = Nothing Then _
    '            Throw New Exception("Nie znaleziono metody " & nazwaMetody)
    '        If Not metoda.IsStatic Then _
    '            Throw New Exception("Poszukiwana metoda powinna być statyczna")
    '        If metoda.ReturnType IsNot zwracanaWartoscMetody Then _
    '            Throw New Exception("Zły typ zwracanej wartości w " & nazwaMetody)
    '        If metoda.GetParameters().Length > 0 Then _
    '            Throw New Exception("Zła liczba argumentów metody " & nazwaMetody)
    '        MessageBox.Show("Znalazłem metodę " & nazwaMetody & " o właściwej sygnaturze")
    '    Catch exc As Exception
    '        MessageBox.Show("Błąd: " & exc.Message & ".")
    '        Return
    '    End Try
    'End Sub

    Private Sub Button4_Click(sender As System.Object, e As System.EventArgs) Handles Button4.Click
        Dim nazwaMetody As String = "GetSystemInfo"

        Try
            Dim a As Assembly = Assembly.LoadFrom(nazwaPlikuDLL)
            Dim klasa As Type = a.GetType(nazwaKlasy)
            If klasa = Nothing Then _
                Throw New Exception("Nie znaleziono klasy " & nazwaKlasy)
            Dim metoda As MethodInfo = klasa.GetMethod(nazwaMetody)
            If metoda = Nothing Then _
                Throw New Exception("Nie znaleziono metody " & nazwaMetody)

            Dim parametry As ParameterInfo() = metoda.GetParameters()
            Dim listaArgumentow As String = vbNewLine & "Lista argumentow:" & vbNewLine
            For Each parametr As ParameterInfo In parametry
                listaArgumentow &= vbTab & parametr.Position.ToString() & ". " & parametr.ParameterType.ToString() & " " & parametr.Name & vbNewLine
            Next

            Dim zwracanyTyp As String = vbNewLine & "Zwracany typ: " & metoda.ReturnParameter.ToString()

            Dim statyczna As String = vbNewLine & "Czy statyczna: " & If(metoda.IsStatic, "tak", "nie")

            MessageBox.Show("Znalazłem metodę " & metoda.Name & vbNewLine & listaArgumentow & zwracanyTyp & vbNewLine & statyczna)
        Catch exc As Exception
            MessageBox.Show("Błąd: " & exc.Message & ".")
            Return
        End Try
    End Sub

    Private Sub Button5_Click(sender As System.Object, e As System.EventArgs) Handles Button5.Click
        Dim nazwaKlasy As String = "Helion.SystemInfo"
        Dim nazwaMetody As String = "Show"
        Dim zwracanaWartoscMetody As Type = GetType(Void)

        Try
            Dim a As Assembly = Assembly.LoadFrom(nazwaPlikuDLL)
            Dim klasa As Type = a.GetType(nazwaKlasy)
            If klasa = Nothing Then _
                Throw New Exception("Nie znaleziono klasy " & nazwaKlasy)
            Dim metoda As MethodInfo = klasa.GetMethod(nazwaMetody)
            If metoda = Nothing Then _
                Throw New Exception("Nie znaleziono metody " & nazwaMetody)
            If Not metoda.IsStatic Then _
                Throw New Exception("Poszukiwana metoda powinna być statyczna")
            If metoda.ReturnType IsNot zwracanaWartoscMetody Then _
                Throw New Exception("Zły typ zwracanej wartości w " & nazwaMetody)
            If metoda.GetParameters().Length > 0 Then _
                Throw New Exception("Zła liczba argumentów metody " & nazwaMetody)

            metoda.Invoke(Nothing, Nothing)
        Catch exc As Exception
            MessageBox.Show("Błąd: " & exc.Message & ".")
            Return
        End Try
    End Sub

    Private Sub Button6_Click(sender As System.Object, e As System.EventArgs) Handles Button6.Click
        Dim nazwaKlasy As String = "Helion.SystemInfo"
        Dim nazwaMetody As String = "GetSystemInfoBuilder"
        Dim zwracanaWartoscMetody As Type = GetType(System.Int32)

        Try
            Dim a As Assembly = Assembly.LoadFrom(nazwaPlikuDLL)
            Dim klasa As Type = a.GetType(nazwaKlasy)
            If klasa = Nothing Then _
                Throw New Exception("Nie znaleziono klasy " & nazwaKlasy)
            Dim metoda As MethodInfo = klasa.GetMethod(nazwaMetody)
            If metoda = Nothing Then _
                Throw New Exception("Nie znaleziono metody " & nazwaMetody)
            If metoda.ReturnType IsNot zwracanaWartoscMetody Then _
                Throw New Exception("Zły typ zwracanej wartości w " & nazwaMetody)
            If metoda.GetParameters().Length <> 2 Then _
                Throw New Exception("Zła liczba argumentów metody " & nazwaMetody)

            Dim obiektSystemInfo As Object = a.CreateInstance(nazwaKlasy)

            Dim informacje As System.Text.StringBuilder = New System.Text.StringBuilder()
            Dim parametry(1) As Object
            parametry(0) = informacje
            parametry(1) = False

            Dim zwroconaWartosc As Integer = CInt(metoda.Invoke(obiektSystemInfo, parametry))
            MessageBox.Show("Zwrócona wartość: " & zwroconaWartosc & " (główna wersja platformy .NET)" & vbNewLine & vbNewLine &
                            "Pobrany łańcuch z informacjami o systemie:" & vbNewLine & informacje.ToString())
        Catch exc As Exception
            MessageBox.Show("Błąd: " & exc.Message & ".")
            Return
        End Try
    End Sub

    Private Sub Button7_Click(sender As System.Object, e As System.EventArgs) Handles Button7.Click
        Try
            Dim obiektSystemInfo As Object = Assembly.LoadFrom(nazwaPlikuDLL).CreateInstance(nazwaKlasy)
            Dim informacje As String = ""
            obiektSystemInfo.GetSystemInfo(informacje, True)
        Catch exc As Exception
            MessageBox.Show("Błąd: " & exc.Message & ".")
        End Try
    End Sub
End Class
