﻿Option Strict On
Option Explicit On
Option Infer Off

Public Structure Ulamek
    Implements IComparable(Of Ulamek)

    Private _licznik, _mianownik As Integer

    Public Sub New(ByVal Licznik As Integer, Optional ByVal Mianownik As Integer = 1)
        If Mianownik = 0 Then Throw New Exception("Mianownik musi być różny od zera")
        Me._licznik = Licznik
        Me._mianownik = Mianownik
    End Sub

    Public Shared Zero As Ulamek = New Ulamek(0)
    Public Shared Jeden As Ulamek = New Ulamek(1)
    Public Shared Polowa As Ulamek = New Ulamek(1, 2)
    Public Shared Cwierc As Ulamek = New Ulamek(1, 4)

    Public Shared Function Info() As String
        Return "Struktura Ulamek, (c) Jacek Matulewski 2010"
    End Function

    Public Overrides Function ToString() As String
        Return _licznik.ToString() & "/" & _mianownik.ToString()
    End Function

    Public Function ToDouble() As Double
        Return _licznik / _mianownik
    End Function

    Public Sub Uprosc()
        'NWD
        Dim mniejsza As Integer = Math.Min(Math.Abs(_licznik), Math.Abs(_mianownik))
        For i As Integer = mniejsza To 1 Step -1
            If (_licznik Mod i = 0) AndAlso (_mianownik Mod i = 0) Then
                _licznik \= i
                _mianownik \= i
            End If
        Next

        'znaki
        If _licznik * _mianownik < 0 Then
            _licznik = -Math.Abs(_licznik)
            _mianownik = Math.Abs(_mianownik)
        Else
            _licznik = Math.Abs(_licznik)
            _mianownik = Math.Abs(_mianownik)
        End If
    End Sub

#Region "Wlasnosci"
    Public Property Licznik As Integer
        Get 'odczyt
            Return _licznik
        End Get
        Set(value As Integer) 'zapis
            _licznik = value
        End Set
    End Property

    Public Property Mianownik As Integer
        Get 'odczyt
            Return _mianownik
        End Get
        Set(value As Integer) 'zapis
            If value = 0 Then Throw New Exception("Mianownik musi być różny od zera")
            _mianownik = value
        End Set
    End Property
#End Region

#Region "Operatory"
    'operatory arytmetyczne
    Public Shared Operator -(u As Ulamek) As Ulamek
        Return New Ulamek(-u.Licznik, u.Mianownik)
    End Operator

    Public Shared Operator +(u1 As Ulamek, u2 As Ulamek) As Ulamek
        Dim wynik As Ulamek = New Ulamek(u1.Licznik * u2.Mianownik + u2.Licznik * u1.Mianownik, u1.Mianownik * u2.Mianownik)
        wynik.Uprosc()
        Return wynik
    End Operator

    Public Shared Operator -(u1 As Ulamek, u2 As Ulamek) As Ulamek
        Dim wynik As Ulamek = New Ulamek(u1.Licznik * u2.Mianownik - u2.Licznik * u1.Mianownik, u1.Mianownik * u2.Mianownik)
        wynik.Uprosc()
        Return wynik
    End Operator

    Public Shared Operator *(u1 As Ulamek, u2 As Ulamek) As Ulamek
        Dim wynik As Ulamek = New Ulamek(u1.Licznik * u2.Licznik, u1.Mianownik * u2.Mianownik)
        wynik.Uprosc()
        Return wynik
    End Operator

    Public Shared Operator /(u1 As Ulamek, u2 As Ulamek) As Ulamek
        Dim wynik As Ulamek = New Ulamek(u1.Licznik * u2.Mianownik, u1.Mianownik * u2.Licznik)
        wynik.Uprosc()
        Return wynik
    End Operator

    'operatory logiczne
    Public Shared Operator =(u1 As Ulamek, u2 As Ulamek) As Boolean
        Return u1.ToDouble() = u2.ToDouble()
    End Operator

    Public Shared Operator <>(u1 As Ulamek, u2 As Ulamek) As Boolean
        Return Not (u1 = u2)
    End Operator

    Public Overrides Function Equals(obj As Object) As Boolean
        If Not TypeOf obj Is Ulamek Then Return False
        Dim u As Ulamek = CType(obj, Ulamek)
        Return Me = u
    End Function

    Public Overrides Function GetHashCode() As Integer
        Return Licznik Xor Mianownik
    End Function

    Public Shared Operator >(u1 As Ulamek, u2 As Ulamek) As Boolean
        Return u1.ToDouble() > u2.ToDouble()
    End Operator

    Public Shared Operator >=(u1 As Ulamek, u2 As Ulamek) As Boolean
        Return u1.ToDouble() >= u2.ToDouble()
    End Operator

    Public Shared Operator <(u1 As Ulamek, u2 As Ulamek) As Boolean
        Return u1.ToDouble() < u2.ToDouble()
    End Operator

    Public Shared Operator <=(u1 As Ulamek, u2 As Ulamek) As Boolean
        Return u1.ToDouble() <= u2.ToDouble()
    End Operator

    Public Overloads Shared Narrowing Operator CType(ByVal u As Ulamek) As Double
        MessageBox.Show("Narrowing")
        Return u.ToDouble()
    End Operator

    Public Overloads Shared Widening Operator CType(n As Integer) As Ulamek
        MessageBox.Show("Widening")
        Return New Ulamek(n)
    End Operator
#End Region

    Public Function CompareTo(u As Ulamek) As Integer _
        Implements IComparable(Of UlamekDemo.Ulamek).CompareTo

        Dim roznica As Double = Me.ToDouble() - u.ToDouble()
        If roznica <> 0 Then roznica /= Math.Abs(roznica)
        Return CInt(roznica)
    End Function

End Structure
