﻿Option Strict On
Option Explicit On
Option Infer Off

Public Class Form1

    Private Async Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click

        'czynność, która będzie wykonywana asynchronicznie
        Dim akcja As Func(Of Object, Long) = Function(argument As Object)
                                                 MessageBox.Show("Zatrzymujemy działanie akcji - " & argument.ToString())
                                                 Return DateTime.Now.Ticks
                                             End Function

        '1) akcja wykonywana synchronicznie
        Dim wynik1 As Long = akcja("synchronicznie")
        MessageBox.Show("Synchronicznie: " & wynik1.ToString())

        '2) akcja wykonywana asynchronicznie przez zadanie        
        Dim zadanie2 As Task(Of Long) = New Task(Of Long)(akcja, "zadanie")
        zadanie2.Start()
        MessageBox.Show("Akcja została uruchomiona")
        Dim wynik2 As Long = zadanie2.Result 'własność Result czeka ze zwróceniem wartości aż zadanie zostanie zakończone
        MessageBox.Show("Zadanie: " & wynik2.ToString())

        '3) akcja wykonywana asynchronicznie - async/await
        Dim zadanie3 As Task(Of Long) = New Task(Of Long)(akcja, "Async/Await")
        zadanie3.Start()
        MessageBox.Show("Akcja została uruchomiona")
        Dim wynik3 As Long = Await zadanie3
        MessageBox.Show("Await: " & wynik3.ToString())
    End Sub

    Private Sub Timer1_Tick(sender As Object, e As EventArgs) Handles Timer1.Tick
        Label1.Text = DateTime.Now.Ticks.ToString()
    End Sub
End Class
