﻿Option Strict On
Option Explicit On
Option Infer Off

Public Class Form1

    Sub Metoda() 'głowa metody, sygnatura
        MessageBox.Show("Hello World!") 'ciało metody
    End Sub

    'Sub Metoda(tekst As String)
    '    MessageBox.Show(tekst)
    'End Sub

    Sub Metoda(tekst As String, Optional tytuł As String = "Komunikat")
        MessageBox.Show(tekst, tytuł)
    End Sub

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        Metoda()
        Metoda("Witaj świecie!")
        Metoda("Witaj świecie!", "Powitanie")
    End Sub

    Private Function Kwadrat(arg As Byte) As Integer
        Return arg * arg
    End Function

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        Dim wynik As Integer = Kwadrat(2)
        MessageBox.Show(wynik.ToString())
    End Sub

    Private Sub zakresDouble(ByRef min As Double, ByRef max As Double)
        min = Double.MinValue
        max = Double.MaxValue
        MessageBox.Show("Liczby double mogą należeć do przedziału (" & min & "," & max & ")")
    End Sub

    Private Sub Button3_Click(sender As System.Object, e As System.EventArgs) Handles Button3.Click
        Dim min As Double = 0, max As Double = 0
        zakresDouble(min, max)
        MessageBox.Show("Liczby double mogą należeć do przedziału (" _
                        & min & "," & max & ")")
    End Sub

    Delegate Sub Uchwyt(tekst As String)

    Private Sub ShowMessage(tekst As String)
        MessageBox.Show(tekst, "Komunikat!", MessageBoxButtons.OK, MessageBoxIcon.Information)
    End Sub

    Event Zdarzenie As Uchwyt

    Private Sub Button4_Click(sender As System.Object, e As System.EventArgs) Handles Button4.Click

        ShowMessage("Wywołanie metody bezpośrednio")

        Dim UchwytMetody As Uchwyt = AddressOf ShowMessage
        UchwytMetody("Wywołanie metody via uchwyt")

        AddHandler Zdarzenie, UchwytMetody
        RaiseEvent Zdarzenie("Wywołanie metody via zdarzenie")
    End Sub

    Delegate Function DInc(n As Integer) As Integer
    Delegate Function DIsEqual(x As Double, y As Double) As Boolean
    Delegate Sub DShow(o As Object)

    Private Sub Button5_Click(sender As System.Object, e As System.EventArgs) Handles Button5.Click

        Dim Inc As DInc = Function(n As Integer) n + 1
        Dim _Inc As Func(Of Integer, Integer) = Function(n As Integer) n + 1
        ShowMessage(Inc(1).ToString())

        Dim IsEqual As DIsEqual = Function(x, y) x = y
        Dim _IsEqual As Func(Of Integer, Integer, Boolean) = Function(x, y) x = y
        MessageBox.Show(IsEqual(1, 1).ToString())

        Dim Show As DShow = Sub(o) MessageBox.Show(o.ToString())
        Dim _Show As Action(Of Object) = Sub(o) MessageBox.Show(o.ToString())
        Show("Komunikat")
        Show(1)

        Dim slowa As String() = {"czereśnia", "jabłko", "borówka", "wiśnia", "jagoda"}
        Dim dlugoscNajkrotszego As Integer = slowa.Min(Function(slowo) slowo.Length)
        MessageBox.Show(dlugoscNajkrotszego.ToString())
    End Sub
End Class
