﻿Public Class Form1
    ' Rysuje elipsy na zakładkach.
    Private Sub tabProject_DrawItem(ByVal sender As Object, ByVal e As System.Windows.Forms.DrawItemEventArgs) Handles tabProject.DrawItem
        ' Pobiera granice rysunku.
        Dim rect As Rectangle = e.Bounds
        If (e.State And DrawItemState.Selected) = DrawItemState.Selected Then
            ' Dodatkowa przestrzeń dla wybranej zakładki.
            rect.X += 4
            rect.Y += 4
            rect.Width -= 8
            rect.Height -= 8
        Else
            rect.X += 2
            rect.Y += 2
            rect.Width -= 4
            rect.Height -= 4
        End If

        ' Wypełnia elipsę kolorem.
        Select Case e.Index
            Case 0
                e.Graphics.FillEllipse(Brushes.Green, rect)
            Case 1
                e.Graphics.FillEllipse(Brushes.Yellow, rect)
            Case 2
                e.Graphics.FillEllipse(Brushes.Red, rect)
        End Select

        ' Obrysowuje elipsę na czarno.
        If (e.State And DrawItemState.Selected) = DrawItemState.Selected Then
            ' Gruba czarna linia obrysowująca elipsę na wybranej zakładce.
            e.Graphics.DrawEllipse( _
                New Pen(Color.Black, 3), _
                rect)
        Else
            e.Graphics.DrawEllipse(Pens.Black, rect)
        End If
    End Sub
End Class
