﻿Public Class Form1
    Private Sub btnPickXmlFile_Click() Handles btnPickXmlFile.Click
        If dlgXmlFile.ShowDialog() = Windows.Forms.DialogResult.OK Then
            MessageBox.Show(dlgXmlFile.FileName)
        End If
    End Sub

    ' Zapewnia, że użytkownik może wybrać tylko mapę bitową.
    Private Sub dlgBitmapFile_FileOk(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles dlgBitmapFile.FileOk
        For Each file_name As String In dlgBitmapFile.FileNames
            ' Sprawdza czy nazwa pliku kończy się łańcuchem .bmp.
            If Not file_name.EndsWith(".bmp") Then
                MessageBox.Show("File '" & file_name & _
                    "' nie jest mapą bitową", _
                    "Niewłaściwy typ pliku", _
                    MessageBoxButtons.OK, _
                    MessageBoxIcon.Exclamation)
                e.Cancel = True
                Exit Sub
            End If
        Next file_name
    End Sub

    Private Sub btnPickBitmapFile_Click() Handles btnPickBitmapFile.Click
        If dlgBitmapFile.ShowDialog() = Windows.Forms.DialogResult.OK Then
            Dim file_names As String = Strings.Join(dlgBitmapFile.FileNames, " ")
            MessageBox.Show(file_names)
        End If
    End Sub
End Class
