﻿Public Class Form1
    ' Pozwala użytkownikowi wybrać nowy font.
    Private Sub btnSetFont_Click() Handles btnSetFont.Click
        ' Zapisuje aktualny kolor i font.
        Dim old_font As Font = Me.Font
        Dim old_color As Color = Me.ForeColor

        dlgFont.ShowColor = True    ' Pozwala wybrać kolor pisma.
        dlgFont.ShowEffects = True  ' Pozwala wybrać efekty Strikeout i Underline.
        dlgFont.ShowApply = True    ' Wyświetla przycisk Zastosuj.
        dlgFont.Font = Me.Font      ' Ustawia początkowy font.

        ' Wyswietla okno dialogowe.
        If dlgFont.ShowDialog() = DialogResult.OK Then
            ' Użytkownik kliknął OK. Stosuje nowy font.
            SetFormFont(dlgFont.Font, dlgFont.Color)
        Else
            ' Użytkownik anulował. Przywraca stary font.
            SetFormFont(old_font, old_color)
        End If
    End Sub

    ' Stosuje font aktualnie wybrany w oknie dialogowym.
    Private Sub dlgFont_Apply(ByVal sender As Object, ByVal e As System.EventArgs) Handles dlgFont.Apply
        Dim dlg As FontDialog = DirectCast(sender, FontDialog)
        SetFormFont(dlg.Font, dlg.Color)
    End Sub

    ' Ustawia własności Font i ForeColor formularza.
    Private Sub SetFormFont(ByVal new_font As Font, ByVal new_color As Color)
        ' Ustawia font i kolor formularza.
        Me.Font = new_font
        Me.ForeColor = new_color
    End Sub
End Class
