﻿Public Class Form1
    ' Uruchomienie długiego procesu.
    Private Sub btnStartProcess_Click() Handles btnStartProcess.Click
        ' Przygotowanie się.
        btnStartProcess.Enabled = False
        btnCancel.Enabled = True
        prgLongProcess.Value = 0

        ' Uruchomienie wątku roboczego.
        bgrLongProcess.WorkerReportsProgress = True
        bgrLongProcess.WorkerSupportsCancellation = True
        bgrLongProcess.RunWorkerAsync()
    End Sub

    ' Anulowanie długiego procesu.
    Private Sub btnCancel_Click() Handles btnCancel.Click
        bgrLongProcess.CancelAsync()
    End Sub

    ' Wyświetlenie postępu.
    Private Sub bgrLongProcess_ProgressChanged(ByVal sender As Object, ByVal e As System.ComponentModel.ProgressChangedEventArgs) Handles bgrLongProcess.ProgressChanged
        prgLongProcess.Value = e.ProgressPercentage
    End Sub

    ' Wątek skończył działanie.
    Private Sub bgrLongProcess_RunWorkerCompleted() Handles bgrLongProcess.RunWorkerCompleted
        btnStartProcess.Enabled = True
        btnCancel.Enabled = False
        prgLongProcess.Value = 0
    End Sub

    ' Wykonuje pracę.
    Private Sub bgrLongProcess_DoWork() Handles bgrLongProcess.DoWork
        ' Ten program tylko marnuje trochę czasu.
        Const NUM_SECONDS As Integer = 5
        For i As Integer = 1 To NUM_SECONDS
            ' Przerwa długości jednej sekundy.
            Dim wait_until As Date = Now.AddSeconds(1)
            Do While Now < wait_until

            Loop

            ' Jeśli użytkownik anulował, należy się zatrzymać.
            If bgrLongProcess.CancellationPending Then Exit Sub

            ' Raportuje o postępie.
            bgrLongProcess.ReportProgress(CInt(100 * i / NUM_SECONDS))
        Next i
    End Sub
End Class
