﻿Imports System.Math
Imports System.Threading

Public Class Form1

    Private m_Ymid As Integer
    Private m_Y As Integer
    Private Const GRID_STEP As Integer = 40

    Private m_GraphThread As Thread

    ' Przygotowanie się.
    Private Sub Form1_Load() Handles MyBase.Load
        m_Ymid = picGraph.ClientSize.Height \ 2
        m_Y = m_Ymid

        ' Tworzy obiekty Bitmap i Graphics.
        Dim wid As Integer = picGraph.ClientSize.Width
        Dim hgt As Integer = picGraph.ClientSize.Height
        Dim bm As New Bitmap(wid, hgt)
        Using gr As Graphics = Graphics.FromImage(bm)

            ' Rysuje linie prowadzące.
            gr.Clear(Color.Blue)
            For i As Integer = m_Ymid To picGraph.ClientSize.Height Step GRID_STEP
                gr.DrawLine(Pens.LightBlue, 0, i, wid - 1, i)
            Next i
            For i As Integer = m_Ymid To 0 Step -GRID_STEP
                gr.DrawLine(Pens.LightBlue, 0, i, wid - 1, i)
            Next i
        End Using ' gr

        picGraph.Image = bm
    End Sub

    ' Zaczyna rysowanie grafu.
    Private Sub btnGraph_Click() Handles btnGraph.Click
        If m_GraphThread Is Nothing Then
            ' Wątek nie działa. Uruchamia go.
            AddStatus("Uruchamianie wątku")

            m_GraphThread = New Thread(AddressOf DrawGraph)
            m_GraphThread.Priority = ThreadPriority.BelowNormal
            m_GraphThread.IsBackground = True
            m_GraphThread.Start()

            AddStatus("Wątek został uruchomiony")

            btnGraph.Text = "Stop"
        Else
            ' The thread is running. Stop it.
            AddStatus("Zatrzymywanie wątku")

            m_GraphThread.Abort()
            ' m_GraphThread.Join()
            m_GraphThread = Nothing

            AddStatus("Wątek został zatrzymany")

            btnGraph.Text = "Start"
        End If
    End Sub

    ' Rysuje graf, aż zostanie zatrzymany.
    Private Sub DrawGraph()
        Try
            ' Generuje wartości pseudolosowe.
            Dim y As Integer = m_Y
            Do
                ' Generuje następną wartość.
                NewValue()

                PlotValue(y, m_Y)
                y = m_Y
            Loop
        Catch ex As Exception
            AddStatus("[Thread] " & ex.Message)
        End Try
    End Sub

    ' Generuje następną wartość.
    Private Sub NewValue()
        ' Wartość zostanie obliczona z opóźnieniem.
        Dim stop_time As Date = Now.AddMilliseconds(20)
        Do While Now < stop_time
        Loop

        ' Oblicza następną wartość.
        Static rnd As New Random
        m_Y += rnd.Next(-4, 5)
        If m_Y < 0 Then m_Y = 0
        If m_Y >= picGraph.ClientSize.Height - 1 Then m_Y = picGraph.ClientSize.Height - 1
    End Sub

    Private Delegate Sub PlotValueDelegate(ByVal old_y As Integer, ByVal new_y As Integer)
    Private Sub PlotValue(ByVal old_y As Integer, ByVal new_y As Integer)
        ' Sprawdza czy jest w wątku roboczym, a więc musi
        ' wywołać główny wątek UI.
        If Me.InvokeRequired Then
            ' Tworzy argumenty dla delegatu.
            Dim args As Object() = {old_y, new_y}

            ' Tworzy delegat.
            Dim plot_value_delegate As PlotValueDelegate
            plot_value_delegate = AddressOf PlotValue

            ' Wywołuje delegat w głównym wątku UI.
            Me.Invoke(plot_value_delegate, args)

            ' Zrobione.
            Exit Sub
        End If

        ' Tworzy obiekty Bitmap i Graphics.
        Dim wid As Integer = picGraph.ClientSize.Width
        Dim hgt As Integer = picGraph.ClientSize.Height
        Dim bm As New Bitmap(wid, hgt)
        Using gr As Graphics = Graphics.FromImage(bm)

            ' Przenosi stare dane o jeden piksel w lewo.
            gr.DrawImage(picGraph.Image, -1, 0)

            ' Czyści prawą krawędź i rysuje linie prowadzące.
            gr.DrawLine(Pens.Blue, wid - 1, 0, wid - 1, hgt - 1)
            For i As Integer = m_Ymid To picGraph.ClientSize.Height Step GRID_STEP
                gr.DrawLine(Pens.LightBlue, wid - 2, i, wid - 1, i)
            Next i
            For i As Integer = m_Ymid To 0 Step -GRID_STEP
                gr.DrawLine(Pens.LightBlue, wid - 2, i, wid - 1, i)
            Next i

            gr.DrawLine(Pens.White, wid - 2, old_y, wid - 1, new_y)

            ' Wyświetla wynik.
            picGraph.Image = bm
            picGraph.Refresh()
        End Using ' gr
    End Sub

    ' Dodaje łańcuch stanu do txtStatus.
    Private Delegate Sub AddStatusDelegate(ByVal txt As String)
    Private Sub AddStatus(ByVal txt As String)
        ' Sprawdza czy jest w wątku roboczym, a więc musi
        ' wywołać główny wątek UI.
        If Me.InvokeRequired Then
            ' Tworzy argumenty dla delegatu.
            Dim args As Object() = {txt}

            ' Tworzy delegat.
            Dim add_status_delegate As AddStatusDelegate
            add_status_delegate = AddressOf AddStatus

            ' Wywołuje delegat w głównym wątku UI.
            Me.Invoke(add_status_delegate, args)

            ' Zrobione.
            Exit Sub
        End If

        txtStatus.Text &= vbCrLf & txt
        txtStatus.Select(txtStatus.Text.Length, 0)
        txtStatus.ScrollToCaret()
    End Sub

    ' Wyświetla bieżący czas.
    Private Sub tmrUpdateClock_Tick() Handles tmrUpdateClock.Tick
        lblTime.Text = Now.ToString("T")
    End Sub
End Class
