﻿Imports System.ComponentModel
Imports System.Globalization
Imports System.Threading

Public Class Form1
    ' Wybranie języka angielskiego.
    Private Sub radEnglish_CheckedChanged() Handles radEnglish.CheckedChanged
        If Not radEnglish.Checked Then Exit Sub
        LoadAllResources(New CultureInfo("en-US"))
    End Sub

    ' Wybranie języka niemieckiego.
    Private Sub radGerman_CheckedChanged() Handles radGerman.CheckedChanged
        If Not radGerman.Checked Then Exit Sub
        LoadAllResources(New CultureInfo("de-DE"))
    End Sub

    ' Załadowanie zasobów dla formularza i wszystkich kontrolek.
    Private Sub LoadAllResources(ByVal culture_info As CultureInfo)
        ' Ustawienie kultury i kultury UI.
        Thread.CurrentThread.CurrentCulture = culture_info
        Thread.CurrentThread.CurrentUICulture = culture_info

        ' Utworzenie obiektu klasy ComponentResourceManager.
        Dim component_resource_manager As New ComponentResourceManager(Me.GetType)

        ' Załadowanie zasobów formularza.
        LoadResources(Me, "$this", component_resource_manager)
    End Sub

    ' Załadowanie odpowiednich zasobów dla obiektu i jego kontrolek.
    Private Sub LoadResources(ByVal parent As Control, ByVal parent_name As String, ByVal component_resource_manager As ComponentResourceManager)
        ' Załadowanie zasobów rodzica.
        component_resource_manager.ApplyResources(parent, parent_name)
        ToolTip1.SetToolTip(parent, component_resource_manager.GetString(parent_name & ".ToolTip"))

        ' Załadowanie zasobów każdej kontrolki potomnej.
        For Each ctl As Control In parent.Controls
            LoadResources(ctl, ctl.Name, component_resource_manager)
        Next ctl
    End Sub
End Class
