﻿Imports System.Drawing.Printing
Imports System.Drawing.Drawing2D

Public Class Form1
    ' Drukuje stronę.
    Private Sub pdocGraph_PrintPage(ByVal sender As Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles pdocGraph.PrintPage
        ' Rysuje marginesy. Pamiętaj, aby to zrobić 
        ' przed transformacją obiektu Graphics.
        e.Graphics.DrawRectangle(Pens.Red, e.MarginBounds)

        ' Ta procedura rysuje wykres słupkowy dla 5 wartości
        ' we współrzędnych drukarki z przedziału 
        ' (100, 100) - (600, 400). 
        Dim picture_rect As New RectangleF(100, 100, 500, 300)
        Dim margin_rect As New RectangleF( _
            e.MarginBounds.X, _
            e.MarginBounds.Y, _
            e.MarginBounds.Width, _
            e.MarginBounds.Height)
        FitPictureToMargins(e.Graphics, picture_rect, margin_rect)

        ' Rysuje wykres słupkowy.
        DrawGraphics(e.Graphics)

        ' Nie ma więcej stron.
        e.HasMorePages = False
    End Sub

    ' Rysuje obraz.
    Private Sub picCanvas_Resize() Handles picCanvas.Resize
        picCanvas.Invalidate()
    End Sub
    Private Sub picCanvas_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles picCanvas.Paint
        ' Czyści obraz.
        e.Graphics.Clear(picCanvas.BackColor)

        ' Ta procedura rysuje wykres słupkowy dla 5 wartości
        ' we współrzędnych drukarki z przedziału 
        ' (100, 100) - (600, 400). 
        ' Transformuje obiekt Graphics, aby wynik umieścić na środku.
        Dim picture_rect As New RectangleF(100, 100, 500, 300)
        Dim margin_rect As New RectangleF( _
            picCanvas.ClientRectangle.X + 3, _
            picCanvas.ClientRectangle.Y + 3, _
            picCanvas.ClientRectangle.Width - 6, _
            picCanvas.ClientRectangle.Height - 6)
        FitPictureToMargins(e.Graphics, picture_rect, margin_rect)

        ' Rysuje wykres słupkowy.
        DrawGraphics(e.Graphics)
    End Sub

    ' Rysuje grafikę.
    Private Sub DrawGraphics(ByVal gr As Graphics)
        ' Rysuje prostokąt wokół wykresu.
        Dim picture_rect As New Rectangle(100, 100, 500, 300)
        gr.FillRectangle(Brushes.LightGray, picture_rect)
        gr.DrawRectangle(Pens.Black, picture_rect)

        ' Rysuje wartości.
        Dim x As Integer = 100
        DrawBar(gr, x, 200, HatchStyle.BackwardDiagonal)
        DrawBar(gr, x, 280, HatchStyle.Vertical)
        DrawBar(gr, x, 240, HatchStyle.ForwardDiagonal)
        DrawBar(gr, x, 170, HatchStyle.Horizontal)
        DrawBar(gr, x, 290, HatchStyle.DiagonalCross)
    End Sub

    ' Rysuje słupek w (x, 400)-(x + 100, 400 - hgt).
    Private Sub DrawBar(ByVal gr As Graphics, ByRef x As Integer, ByVal hgt As Integer, ByVal hatch_style As HatchStyle)
        Dim rect As New Rectangle(x, 400 - hgt, 100, hgt)
        Using hatch_brush As New HatchBrush(hatch_style, Color.Black, Color.White)
            gr.FillRectangle(hatch_brush, rect)
        End Using
        gr.DrawRectangle(Pens.Black, rect)
        x += 100
    End Sub

    ' Transformuje obiekt Graphics, aby wyśrodkować prostokąt
    ' picture_bounds w margin_bounds.
    Private Sub CenterPictureInMargins(ByVal gr As Graphics, ByVal picture_bounds As RectangleF, ByVal margin_bounds As RectangleF)
        ' Usuwa wszelkie transformacje.
        gr.ResetTransform()

        ' Stosuje transformację.
        Dim dx As Single = _
            margin_bounds.Left - picture_bounds.Left + _
            (margin_bounds.Width - picture_bounds.Width) / 2
        Dim dy As Single = _
            margin_bounds.Top - picture_bounds.Top + _
            (margin_bounds.Height - picture_bounds.Height) / 2
        gr.TranslateTransform(dx, dy)
    End Sub

    ' Transformuje obiekt Graphics, aby dopasować prostokąt 
    ' picture_bounds do margin_bounds i wyśrodkować go.
    Private Sub FitPictureToMargins(ByVal gr As Graphics, ByVal picture_bounds As RectangleF, ByVal margin_bounds As RectangleF)
        ' Usuwa wszelkie transformacje.
        gr.ResetTransform()

        ' Translaacja w celu ustawienia środka picture_bounds na początku układu.
        gr.TranslateTransform( _
            -(picture_bounds.Left + picture_bounds.Width / 2), _
            -(picture_bounds.Top + picture_bounds.Height / 2))

        ' Skalowanie, aby dopasować picture_bounds do margin_bounds.
        ' Porównanie współczynników proporcji.
        Dim margin_aspect As Single = margin_bounds.Height / margin_bounds.Width
        Dim picture_aspect As Single = picture_bounds.Height / picture_bounds.Width
        Dim scale As Single
        If picture_aspect > margin_aspect Then
            ' picture_bounds jest względnie wysoki i chudy.
            ' Rozciąga go maksymalnie.
            scale = margin_bounds.Height / picture_bounds.Height
        Else
            ' picture_bounds jest względnie krótki i szeroki.
            ' Rozciąga go maksymalnie w poziomie.
            scale = margin_bounds.Width / picture_bounds.Width
        End If
        ' Skalowanie.
        gr.ScaleTransform(scale, scale, MatrixOrder.Append)

        ' Translacja ustawiająca początek na środku margin_bounds.
        gr.TranslateTransform( _
            margin_bounds.Left + margin_bounds.Width / 2, _
            margin_bounds.Top + margin_bounds.Height / 2, _
            MatrixOrder.Append)
    End Sub

    ' Wyświetla okno dialogowe podglądu wydruku.
    Private Sub mnuFilePrintPreview_Click() Handles mnuFilePrintPreview.Click
        dlgPrintPreview.ShowDialog()
    End Sub
End Class
