﻿Imports System.Drawing.Drawing2D

Public Class Form1
    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        ' Rysuje docelowy prostokąt.
        Dim device_rect As Rectangle
        If radLarge.Checked Then
            device_rect = New Rectangle(50, 50, 150, 150)
        ElseIf radNarrow.Checked Then
            device_rect = New Rectangle(50, 50, 50, 150)
        Else
            device_rect = New Rectangle(50, 200, 150, -150)
        End If

        e.Graphics.DrawRectangle(Pens.Black, device_rect)

        ' Konwersja między współrzędnymi świata i urządzenia.
        Dim world_rect As New Rectangle(0, 0, 1, 1)
        MapRectangles(e.Graphics, world_rect, device_rect)

        ' Rysuje buźkę.
        DrawSmiley(e.Graphics)
    End Sub

    ' Rysuje buźkę w prostokącie.
    ' 0 <= X <= 1, 0 <= Y <= 1.
    Private Sub DrawSmiley(ByVal gr As Graphics)
        Using the_pen As New Pen(Color.Black, 0)
            gr.FillEllipse(Brushes.Yellow, 0, 0, 1, 1)              ' Buźka.
            gr.DrawEllipse(the_pen, 0, 0, 1, 1)
            gr.DrawArc(the_pen, 0.2!, 0.2!, 0.6!, 0.6!, 0.0!, 180.0!)         ' Uśmiech.
            gr.FillEllipse(Brushes.Black, 0.4!, 0.4!, 0.2!, 0.25!)      ' Nos.
            gr.FillEllipse(Brushes.White, 0.25!, 0.15!, 0.2!, 0.25!)    ' Lewe oko.
            gr.DrawEllipse(the_pen, 0.25!, 0.15!, 0.2!, 0.25!)
            gr.FillEllipse(Brushes.Black, 0.35!, 0.2!, 0.1!, 0.15!)
            gr.FillEllipse(Brushes.White, 0.55!, 0.15!, 0.2!, 0.25!)    ' Prawe oko.
            gr.DrawEllipse(the_pen, 0.55!, 0.15!, 0.2!, 0.25!)
            gr.FillEllipse(Brushes.Black, 0.65!, 0.2!, 0.1!, 0.15!)
        End Using
    End Sub

    ' Konwersja między współrzędnymi świata i urządzenia.
    Private Sub MapRectangles(ByVal gr As Graphics, ByVal world_rect As Rectangle, ByVal device_rect As Rectangle)
        ' Zeruje transformację.
        gr.ResetTransform()

        ' Translacja mająca na celu ustawienie środka prostokąta
        ' o współrzędnych świata na początku układu.
        gr.TranslateTransform( _
            CSng(-(world_rect.X + world_rect.Width / 2)), _
            CSng(-(world_rect.Y + world_rect.Height / 2)), _
            MatrixOrder.Append)

        ' Skalowanie.
        gr.ScaleTransform( _
            CSng(device_rect.Width / world_rect.Width), _
            CSng(device_rect.Height / world_rect.Height), _
            MatrixOrder.Append)

        ' Translacja mająca na celu przeniesienie początku na środek
        ' prostokąta o współrzędnych urządzenia.
        gr.TranslateTransform( _
            CSng(device_rect.X + device_rect.Width / 2), _
            CSng(device_rect.Y + device_rect.Height / 2), _
            MatrixOrder.Append)
    End Sub

    Private Sub rad_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles radLarge.CheckedChanged, radNarrow.CheckedChanged, radFlipped.CheckedChanged
        Me.Invalidate()
    End Sub
End Class
