﻿Public Class Form1
    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        ' Rysuje buźkę.
        Dim bm As New Bitmap(101, 101)
        Using gr As Graphics = Graphics.FromImage(bm)
            gr.FillEllipse(Brushes.Yellow, 0, 0, 99, 99)    ' Buźka.
            gr.DrawEllipse(Pens.Black, 0, 0, 99, 99)
            gr.DrawArc(Pens.Black, 20, 20, 60, 60, 0, 180)  ' Uśmiech.
            gr.FillEllipse(Brushes.Black, 40, 40, 20, 25)   ' Nos.
            gr.FillEllipse(Brushes.White, 25, 15, 20, 25)   ' Lewe oko.
            gr.DrawEllipse(Pens.Black, 25, 15, 20, 25)
            gr.FillEllipse(Brushes.Black, 35, 20, 10, 15)
            gr.FillEllipse(Brushes.White, 55, 15, 20, 25)   ' Prawe oko.
            gr.DrawEllipse(Pens.Black, 55, 15, 20, 25)
            gr.FillEllipse(Brushes.Black, 65, 20, 10, 15)
        End Using

        ' Wyświetla w pełnych wymiarach.
        e.Graphics.DrawImage(bm, 10, 10)

        ' Pobiera dostępne tryby interpolacji.
        Dim modes As Array = _
            Drawing2D.InterpolationMode.GetValues(GetType(Drawing2D.InterpolationMode))

        ' Wyświetla przy użyciu trybów w pomniejszeniu.
        Dim x As Integer = 10
        Dim y As Integer = 120
        For Each mode As Drawing2D.InterpolationMode In modes
            DrawSample(e.Graphics, bm, mode, x, y)
        Next mode
        Exit Sub

        DrawSample(e.Graphics, bm, Drawing2D.InterpolationMode.Default, x, y)
        DrawSample(e.Graphics, bm, Drawing2D.InterpolationMode.Low, x, y)
        DrawSample(e.Graphics, bm, Drawing2D.InterpolationMode.High, x, y)
        DrawSample(e.Graphics, bm, Drawing2D.InterpolationMode.Bilinear, x, y)
        x = 10
        y += 100

        DrawSample(e.Graphics, bm, Drawing2D.InterpolationMode.Bicubic, x, y)
        DrawSample(e.Graphics, bm, Drawing2D.InterpolationMode.NearestNeighbor, x, y)
        DrawSample(e.Graphics, bm, Drawing2D.InterpolationMode.HighQualityBilinear, x, y)
        DrawSample(e.Graphics, bm, Drawing2D.InterpolationMode.HighQualityBicubic, x, y)
    End Sub

    Private Sub DrawSample(ByVal gr As Graphics, ByVal bm As Bitmap, ByVal interpolation_mode As Drawing2D.InterpolationMode, ByRef x As Integer, ByRef y As Integer)
        If interpolation_mode = Drawing2D.InterpolationMode.Invalid Then Exit Sub

        gr.DrawString(interpolation_mode.ToString, Me.Font, Brushes.Black, x, y)
        gr.InterpolationMode = interpolation_mode
        gr.DrawImage(bm, x, y + 20, 50, 50)

        gr.InterpolationMode = interpolation_mode
        Dim src_rect As New Rectangle(35, 35, 30, 30)
        Dim dest_rect As New Rectangle(x + 60, y + 20, 50, 50)
        gr.DrawImage(bm, dest_rect, src_rect, GraphicsUnit.Pixel)
        gr.DrawRectangle(Pens.Black, dest_rect)

        x += 120
        If x + 100 > Me.ClientSize.Width Then
            x = 10
            y += 100
        End If
    End Sub
End Class
