﻿Public Class Form1
    ' Zapamiętuje pochodzenie danych.
    Private m_DragSource As ListBox = Nothing

    ' Zezwolenie na zdarzenia przeciągania.
    Private Sub Form1_Load() Handles MyBase.Load
        lstUnselected.AllowDrop = True
        lstSelected.AllowDrop = True
    End Sub

    ' Początek przeciągania.
    Private Sub List_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles lstSelected.MouseDown, lstUnselected.MouseDown
        ' Upewnienie się, że to jest właściwy przycisk.
        If e.Button <> Windows.Forms.MouseButtons.Right Then Exit Sub

        ' Wybór elementy w tym miejscu.
        Dim this_list As ListBox = DirectCast(sender, ListBox)
        this_list.SelectedIndex = this_list.IndexFromPoint(e.X, e.Y)
        If this_list.SelectedIndex < 0 Then Exit Sub

        ' Zapamiętanie, gdzie zaczęło się przeciąganie.
        m_DragSource = this_list

        ' Początek przeciągania.
        this_list.DoDragDrop( _
            this_list.SelectedItem.ToString, _
            DragDropEffects.Move)

        ' Koniec przeciągania.
        m_DragSource = Nothing
    End Sub

    ' Wyróżnienie elementu pod myszą.
    Private Sub List_DragOver(ByVal sender As Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles lstSelected.DragOver, lstUnselected.DragOver
        If m_DragSource Is Nothing Then Exit Sub

        e.Effect = DragDropEffects.Move
        Dim this_list As ListBox = DirectCast(sender, ListBox)
        Dim pt As Point = _
            this_list.PointToClient(New Point(e.X, e.Y))
        Dim drop_index As Integer = _
            this_list.IndexFromPoint(pt.X, pt.Y)
        this_list.SelectedIndex = drop_index
    End Sub

    ' Usunięcie wyróżnienia, gdy mysz zostanie przesunięta.
    Private Sub List_DragLeave(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstSelected.DragLeave, lstUnselected.DragLeave
        Dim this_list As ListBox = DirectCast(sender, ListBox)
        this_list.SelectedIndex = -1
    End Sub

    ' Przyjęcie upuszczanych danych.
    Private Sub List_DragDrop(ByVal sender As Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles lstSelected.DragDrop, lstUnselected.DragDrop
        Dim this_list As ListBox = DirectCast(sender, ListBox)
        MoveItem(e.Data.GetData(DataFormats.Text).ToString, _
            m_DragSource, this_list, e.X, e.Y)
    End Sub

    ' Przeniesienie wartości txt z drag_source do drop_target.
    Private Sub MoveItem(ByVal txt As String, ByVal drag_source As ListBox, _
     ByVal drop_target As ListBox, ByVal X As Integer, ByVal Y As Integer)
        ' Sprawdzenie, który element został wybrany w punkcie docelowym.
        Dim drop_index As Integer = drop_target.SelectedIndex
        If drop_index < 0 Then
            ' Dodanie na końcu.
            drop_index = drop_target.Items.Add(txt)
        Else
            ' Dodanie przed zaznaczonym elementem.
            drop_target.Items.Insert(drop_target.SelectedIndex, txt)
        End If

        ' Zaznaczenie elementu.
        drop_target.SelectedIndex = drop_index

        ' Usunięcie wartości z drag_source.
        If drag_source Is drop_target Then
            ' Upewnienie się, że nie usuwamy elementu, który dodaliśmy.
            Dim target_index As Integer = drag_source.FindStringExact(txt)
            If target_index = drop_index Then _
                target_index = drag_source.FindStringExact(txt, target_index)
            drag_source.Items.RemoveAt(target_index)
        Else
            ' Usunięcie elementu.
            drag_source.Items.Remove(txt)
        End If
    End Sub
End Class
