﻿' Wymaga referencji do System.Xml.
Imports System.Xml.Serialization
Imports System.IO

Public Class Form1
    <Serializable()> _
    Public Class Employee
        Public FirstName As String
        Public LastName As String
        Public Sub New()
        End Sub
        Public Sub New(ByVal first_name As String, ByVal last_name As String)
            FirstName = first_name
            LastName = last_name
        End Sub
    End Class

    ' Kopiuje obiekt Employee do schowka.
    Private Sub btnCopy_Click() Handles btnCopy.Click
        Dim emp As New Employee(txtFirstName.Text, txtLastName.Text)
        Dim data_object As New DataObject
        data_object.SetData("Employee", emp)
        Clipboard.SetDataObject(data_object)
    End Sub

    ' Wkleja dane ze schowka.
    Private Sub btnPaste_Click() Handles btnPaste.Click
        Dim data_object As IDataObject = Clipboard.GetDataObject()
        If data_object.GetDataPresent("Employee") Then
            Dim emp As Employee = DirectCast(data_object.GetData("Employee"), Employee)
            txtPasteFirstName.Text = emp.FirstName
            txtPasteLastName.Text = emp.LastName
        End If
    End Sub
End Class
