﻿Public Class RowSortingListView
    Inherits ListView

    Public Shadows Event ColumnClick(ByVal column_number As Integer)

    ' Konwwertuje zdarzenie ColumnClick klasy nadrzędnej
    ' na naszą wersję.
    Private Sub RowSortingListView_ColumnClick(ByVal sender As Object, _
     ByVal e As System.Windows.Forms.ColumnClickEventArgs) Handles MyBase.ColumnClick
        RaiseEvent ColumnClick(e.Column)
    End Sub

    ' Przesłonięcie metody Clear, aby usuwała tylko elementy Book.
    Public Shadows Sub Clear()
        For Each item As ListViewItem In Me.Items
            If item.Text = "Book" Then item.Remove()
        Next item
    End Sub

    ' Ponowna implementacja własności Sorting.
    Private m_Sorting As SortOrder
    Public Shadows Property Sorting() As SortOrder
        Get
            Return m_Sorting
        End Get
        Set(ByVal Value As SortOrder)
            ' Zapisanie nowej wartości.
            m_Sorting = Value

            ' Utworzenie nowego ListViewItemSorter w razie potrzeby.
            If m_Sorting = SortOrder.None Then
                MyBase.ListViewItemSorter = Nothing
            Else
                MyBase.ListViewItemSorter = _
                    New ListViewComparerAllColumns(m_Sorting)
            End If
        End Set
    End Property

#Region "ListViewComparerAllColumns"
    ' Implementuje komparatora ListViewItem 
    ' sortującego wszystkie kolumny.
    Private Class ListViewComparerAllColumns
        Implements IComparer

        ' Rosnąco lub malejąco.
        Private m_SortOrder As SortOrder

        Public Sub New(ByVal sort_order As SortOrder)
            m_SortOrder = sort_order
        End Sub

        ' Porównuje podelementy dwóch elementów.
        Public Function Compare(ByVal x As Object, ByVal y As Object) As Integer _
         Implements System.Collections.IComparer.Compare
            ' ListViewItem.
            Dim item_x As ListViewItem = DirectCast(x, ListViewItem)
            Dim item_y As ListViewItem = DirectCast(y, ListViewItem)

            ' Wartości ListViewItem.
            Dim values_x As String = ListViewItemValue(item_x)
            Dim values_y As String = ListViewItemValue(item_y)

            ' Porównanie wartości.
            If m_SortOrder = SortOrder.Ascending Then
                Return String.Compare(values_x, values_y)
            Else
                Return String.Compare(values_y, values_x)
            End If
        End Function

        ' Zwraca łańcuch zawierający oddzielone wartości
        ' ListViewItem.
        Private Function ListViewItemValue(ByVal lvi As ListViewItem, _
         Optional ByVal delimiter As String = vbTab) As String
            Dim txt As String = ""
            For i As Integer = 0 To lvi.SubItems.Count - 1
                txt &= delimiter & lvi.SubItems(i).Text
            Next i
            Return txt.Substring(delimiter.Length)
        End Function
    End Class
#End Region ' ListViewComparerAllColumns

End Class
