﻿Imports System.Runtime.CompilerServices

Public Class Form1

    Private all_customers As New List(Of Customer)
    Private all_orders As New List(Of Order)
    Private all_orderitems As New List(Of OrderItem)

    Private Sub Form1_Load() Handles MyBase.Load
        all_customers.Add(New Customer() With {.Name = "Alice", .CustId = 100, .AccountBalance = 10})
        all_customers.Add(New Customer() With {.Name = "Bob", .CustId = 200, .AccountBalance = 30})
        all_customers.Add(New Customer() With {.Name = "Cindy", .CustId = 300, .AccountBalance = -110})
        all_customers.Add(New Customer() With {.Name = "Dan", .CustId = 400, .AccountBalance = -95})

        all_orders.Add(New Order() With {.CustId = 100, .OrderId = 1001, .OrderDate = #4/1/2008#})
        all_orders.Add(New Order() With {.CustId = 100, .OrderId = 1002, .OrderDate = #4/5/2008#})
        all_orders.Add(New Order() With {.CustId = 200, .OrderId = 1003, .OrderDate = #4/12/2008#})
        all_orders.Add(New Order() With {.CustId = 200, .OrderId = 1004, .OrderDate = #4/19/2008#})
        all_orders.Add(New Order() With {.CustId = 300, .OrderId = 1005, .OrderDate = #4/7/2008#})
        all_orders.Add(New Order() With {.CustId = 400, .OrderId = 1006, .OrderDate = #4/9/2008#})
        all_orders.Add(New Order() With {.CustId = 400, .OrderId = 1007, .OrderDate = #4/22/2008#})

        all_orderitems.Add(New OrderItem() With {.OrderId = 1001, .ItemName = "Pencils, dozen", .UnitPrice = 0.75, .Quantity = 3})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1001, .ItemName = "Notepad", .UnitPrice = 1.15, .Quantity = 12})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1001, .ItemName = "Soda, 12-pack", .UnitPrice = 2.75, .Quantity = 4})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1002, .ItemName = "Candy bar", .UnitPrice = 0.65, .Quantity = 144})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1002, .ItemName = "Laptop computer", .UnitPrice = 1445.93, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1003, .ItemName = "Copy paper, ream", .UnitPrice = 2.18, .Quantity = 10})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1004, .ItemName = "Programming book", .UnitPrice = 27.95, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1005, .ItemName = "Pencils, dozen", .UnitPrice = 0.75, .Quantity = 4})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1005, .ItemName = "Dry erase markers, 5-pack", .UnitPrice = 3.8, .Quantity = 2})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1006, .ItemName = "Fancy mouse", .UnitPrice = 42.57, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1007, .ItemName = "12TB flash drive", .UnitPrice = 107.75, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1007, .ItemName = "Pencils, dozen", .UnitPrice = 0.75, .Quantity = 1})

        'Dim q1 = _
        '    From cust In all_customers _
        '    Order By cust.Name _
        '    Select cust
        Dim q1 = all_customers. _
            OrderBy(Of String)(AddressOf OrderByNameReversed)
        For Each cust As Customer In q1
            Dim lvi As ListViewItem = lvwAllCustomers.Items.Add(cust.Name)
            lvi.SubItems.Add(FormatCurrency(cust.AccountBalance))
        Next cust

        'Dim q2 = _
        '    From cust In all_customers _
        '    Where cust.AccountBalance < 0 _
        '    Order By cust.AccountBalance Ascending _
        '    Select cust.Name, cust.AccountBalance
        Dim q2 = all_customers. _
            Where(AddressOf OwesMoney). _
            OrderBy(Of Decimal)(AddressOf OrderByAmount). _
            Select(Of CustInfo)(AddressOf SelectFields)
        'Debug.WriteLine(TypeName(q2))
        For Each cust_info As CustInfo In q2
            'Debug.WriteLine(TypeName(cust))
            Dim lvi As ListViewItem = lvwDelinquentCustomers.Items.Add(cust_info.CustName)
            lvi.SubItems.Add(FormatCurrency(cust_info.Balance))
        Next cust_info

        Dim total_due = all_customers.Aggregate(Of Decimal)(0, AddressOf TotalDue)
        lvwAggregates.Items.Add("Total Due:").SubItems.Add(FormatCurrency(total_due))

        Dim ave_due = all_customers.Average(AddressOf MinimumDue)
        lvwAggregates.Items.Add("Average Due:").SubItems.Add(FormatCurrency(ave_due))

        Dim ave_bal = all_customers.Average(AddressOf TotalBalance)
        lvwAggregates.Items.Add("Average Balance:").SubItems.Add(FormatCurrency(ave_bal))

        Dim my_min = all_customers.MyMin(AddressOf TotalBalance)
        lvwAggregates.Items.Add("MyMin Balance:").SubItems.Add(FormatCurrency(my_min))

        Dim std_dev = all_customers.StdDev(AddressOf TotalBalance)
        lvwAggregates.Items.Add("StdDev Balance:").SubItems.Add(FormatCurrency(std_dev))

        Dim std_dev2 = all_customers.Select(Of Decimal)(AddressOf SelectBalance).StdDev()
        lvwAggregates.Items.Add("StdDev Balance 2:").SubItems.Add(FormatCurrency(std_dev))

        Dim q3 = From cust In all_customers _
            Select cust.AccountBalance
        lvwAggregates.Items.Add("LINQ StdDev:").SubItems.Add(FormatCurrency(q3.StdDev()))

        Dim q4 = (From cust In all_customers _
                 Select cust).Randomize()
        For Each v In q4
            lvwRandom.Items.Add(v.Name).SubItems.Add(FormatCurrency(v.AccountBalance))
        Next v

        Dim std_due As Decimal = _
            (From cust In all_customers _
            Where cust.AccountBalance < 0 _
            Select cust.AccountBalance).StdDev()
        lvwAggregates.Items.Add("StdDev Due:").SubItems.Add(FormatCurrency(std_due))

        Dim std_due2 As Decimal = _
            (From cust In all_customers _
             Where cust.AccountBalance < 0 _
             Select cust).StdDev(AddressOf TotalBalance)
        lvwAggregates.Items.Add("LINQ StdDev Due:").SubItems.Add(FormatCurrency(std_due2))
    End Sub

    Private Function OrderByNameReversed(ByVal c As Customer) As String
        Dim reverse_name As String = ""
        For Each ch As Char In c.Name
            reverse_name = ch & reverse_name
        Next ch
        Return reverse_name
    End Function

    Private Function OwesMoney(ByVal c As Customer) As Boolean
        Return c.AccountBalance < 0
    End Function

    Private Function OrderByAmount(ByVal c As Customer) As Decimal
        Return -c.AccountBalance
    End Function

    Private Function SelectFields(ByVal c As Customer, ByVal index As Integer) As CustInfo
        Return New CustInfo() With {.CustName = "[" & c.Name & "]", .Balance = c.AccountBalance}
    End Function

    Private Function SelectBalance(ByVal c As Customer, ByVal index As Integer) As Decimal
        Return c.AccountBalance
    End Function

    ' Zwraca saldo klienta lub
    ' 0, jeśli saldo jest ujemne.
    Private Function TotalDue(ByVal total_in As Decimal, ByVal c As Customer) As Decimal
        Return total_in + Math.Min(0, c.AccountBalance)
    End Function

    Private Function MinimumDue(ByVal c As Customer) As Decimal
        Return Math.Min(0, c.AccountBalance + 50)
    End Function

    ' Zwraca saldo konta.
    Private Function TotalBalance(ByVal c As Customer) As Decimal
        Return c.AccountBalance
    End Function
End Class

Public Class CustInfo
    Public CustName As String
    Public Balance As Decimal
End Class

Public Class Customer
    Public Name As String
    Public CustId As Integer
    Public AccountBalance As Decimal
End Class

Public Class Order
    Public OrderDate As Date
    Public OrderId As Integer
    Public CustId As Integer
End Class

Public Class OrderItem
    Public OrderId As Integer
    Public ItemName As String
    Public Quantity As Integer
    Public UnitPrice As Decimal
End Class

Module IEnumerableExtensions
    <Extension()> _
    Public Function MyMin(Of T)(ByVal source As IEnumerable(Of T), ByVal selector As Func(Of T, Double)) As Double
        Dim min_value As Double = Double.MaxValue
        For Each v In source
            Dim test_value As Double = selector(v)
            If min_value > test_value Then min_value = test_value
        Next v
        Return min_value
    End Function

    ' Zwraca odchylenie standardowe wartości
    ' w IEnumerable(Of Decimal).
    <Extension()> _
    Public Function StdDev(ByVal source As IEnumerable(Of Decimal)) As Decimal
        ' Suma całkowita.
        Dim total As Decimal = 0
        For Each value As Decimal In source
            total += value
        Next value

        ' Obliczanie średniej.
        Dim mean As Decimal = total / source.Count

        ' Obliczanie sum kwadratów odchyleń.
        Dim total_devs As Decimal = 0
        For Each value As Decimal In source
            Dim dev As Decimal = value - mean
            total_devs += dev * dev
        Next value

        ' Zwraca odchylenie standardowe.
        Return Math.Sqrt(total_devs / (source.Count - 1))
    End Function

    ' Zwraca odchylenie standardowe
    ' wartości w IEnumerable(Of T).
    ' Funkcja selektora pobiera
    ' dziesiętną wartość każdego obiektu T.
    ' (FNa przykład selektor może zwrócić
    ' AccountBalance dla obiektu Customer.)
    <Extension()> _
    Public Function StdDev(Of T)(ByVal source As IEnumerable(Of T), ByVal selector As Func(Of T, Decimal)) As Decimal
        ' Suma całkowita.
        Dim total As Decimal = 0
        For Each value As T In source
            total += selector(value)
        Next value

        ' Obliczanie średniej.
        Dim mean As Decimal = total / source.Count

        ' Obliczanie sum kwadratów odchyleń.
        Dim total_devs As Decimal = 0
        For Each value As T In source
            Dim dev As Decimal = selector(value) - mean
            total_devs += dev * dev
        Next value

        ' Zwraca odchylenie standardowe.
        Return Math.Sqrt(total_devs / (source.Count - 1))
    End Function

    ' RZwraca odchylenie standardowe
    ' wartości w tablicy typu Decimal.
    <Extension()> _
    Public Function StdDev(ByVal values() As Decimal) As Decimal
        Dim total As Decimal = values.Sum()
        Dim mean As Decimal = total / values.Length

        ' Oblicza sumę kwadratów odchyleń.
        Dim devs As Decimal = 0
        For i As Integer = 0 To values.Length - 1
            Dim dev As Decimal = (values(i) - mean)
            devs += dev * dev
        Next i

        Return Math.Sqrt(devs / (values.Length - 1))
    End Function

    <Extension()> _
    Public Function ArrayStdDev(ByVal values() As Decimal) As Decimal
        Dim total As Decimal = values.Sum()
        Dim mean As Decimal = total / values.Length

        ' Obliczanie sumy kwadratów odchyleń.
        Dim devs As Decimal = 0
        For i As Integer = 0 To values.Length - 1
            Dim dev As Decimal = (values(i) - mean)
            devs += dev * dev
        Next i

        Return Math.Sqrt(devs / (values.Length - 1))
    End Function

    <Extension()> _
    Public Function Randomize(Of T)(ByVal source As IEnumerable(Of T)) As IEnumerable(Of T)
        Dim rand As New Random
        Dim values() As T = source.ToArray()
        Dim num_values As Integer = values.Length
        For i As Integer = 0 To num_values - 2
            Dim j As Integer = rand.Next(i, num_values)
            Dim temp As T = values(i)
            values(i) = values(j)
            values(j) = temp
        Next i

        Return values
    End Function
End Module