﻿Imports System.Data
Imports System.Data.OleDb

Public Class Form1
    ' Zwraca łańcuch połączenia dla bazy danych w naszym katalogu z kodem.
    Private Function MakeConnectString() As String
        ' Zwraca łańcuch połączenia, 
        ' jeśli został już zbudowany.
        Static connect_string As String = ""
        If connect_string.Length > 0 Then Return connect_string

        ' Utworzenie ścieżki bazy danych.
        Dim db_path As String = Application.StartupPath & ""
        db_path = db_path.Substring(0, db_path.LastIndexOf("\bin\"))

        ' Utworzenie łańcucha połączenia.
        connect_string = _
            "Provider=Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=""" & db_path & "\CustomerAccounts.mdb"";" & _
            "Persist Security Info=False"

        Return connect_string
    End Function

    Private Sub Form1_Load() Handles MyBase.Load
        ' Otwarcie połączenia.
        Dim connAccounts As New OleDbConnection(MakeConnectString())
        connAccounts.Open()

        ' Wyświetlenie aktualnych sald.
        ShowValues(connAccounts)

        ' Zamknięcie połączenia.
        connAccounts.Close()
    End Sub

    ' Wyświetlenie wartości kont.
    Private Sub ShowValues(ByVal conn As OleDbConnection)
        Dim txt As String = ""
        Dim select_cmd As New OleDbCommand( _
            "SELECT * FROM Accounts", _
            conn)
        Dim reader As OleDbDataReader = select_cmd.ExecuteReader()

        lstValues.Items.Clear()
        Do While reader.Read()
            lstValues.Items.Add( _
                reader.Item("AccountName").ToString & ": " & _
                reader.Item("Balance").ToString)
        Loop

        reader.Close()
    End Sub

    ' Dokonanie przelewu.
    Private Sub btnUpdate_Click() Handles btnUpdate.Click
        ' Otwarcie połączenia.
        Dim connAccounts As New OleDbConnection(MakeConnectString())
        connAccounts.Open()

        ' Dokonanie transakcji.
        Dim trans As OleDbTransaction = _
            connAccounts.BeginTransaction(IsolationLevel.ReadCommitted)

        ' MUtworzenie polecenia dla tego połączenia
        ' i tej transakcji.
        Dim cmd As New OleDbCommand( _
            "UPDATE Accounts SET Balance=Balance + ? WHERE AccountName=?", _
            connAccounts, _
            trans)

        ' Utworzenie parametrów dla pierwszego polecenia.
        cmd.Parameters.Add(New OleDbParameter("Balance", _
            Decimal.Parse(txtAmount.Text)))
        cmd.Parameters.Add(New OleDbParameter("AccountName", _
            "Alice's Software Emporium"))

        ' Wykonanie drugiego polecenia.
        cmd.ExecuteNonQuery()

        ' Utworzenie parametrów dla drugiego polecenia.
        cmd.Parameters.Clear()
        cmd.Parameters.Add(New OleDbParameter("Balance", _
            -Decimal.Parse(txtAmount.Text)))
        cmd.Parameters.Add(New OleDbParameter("AccountName", _
            "Bob's Consulting"))

        ' Wykonanie drugiego polecenia.
        cmd.ExecuteNonQuery()

        ' Zatwierdzenie transakcji.
        If MessageBox.Show( _
            "Zatwierdzić transakcję?", _
            "Zatwierdzić?", _
            MessageBoxButtons.YesNo, _
            MessageBoxIcon.Question) = Windows.Forms.DialogResult.Yes _
        Then
            ' Zatwierdzenie transakcji.
            trans.Commit()
        Else
            ' Cofnięcie transakcji.
            trans.Rollback()
        End If

        ' Wyświetlenie bieżących sald.
        ShowValues(connAccounts)

        ' Zamknięcie połączenia.
        connAccounts.Close()
    End Sub
End Class
