﻿Public Class Form1
    ' Jeśli kontrolka TextBox nie zawiera liczby całkowitej z przedziału min_value-max_value,
    ' zostaje wyświetlony komunikat o błędzie, kontrolka ta jest aktywowana do przyjmowania danych, i
    ' zostaje zwrócona wartość False.
    ' W przeciwnym przypadku zostaje zwrócona wartość True i podana liczba.
    Private Function IsValidInteger(ByRef result As Integer, ByVal txt As TextBox, ByVal field_name As String, Optional ByVal min_value As Integer = Integer.MinValue, Optional ByVal max_value As Integer = Integer.MaxValue) As Boolean
        ' Check for blank entry.
        Dim num_items_txt As String = txt.Text
        If num_items_txt.Length < 1 Then
            MessageBox.Show("Wprowadź liczbę " & field_name & ".")
            txt.Focus()
            Return False
        End If

        ' See if it's numeric.
        If Not IsNumeric(num_items_txt) Then
            MessageBox.Show(field_name & " musi być liczbą.")
            txt.Select(0, num_items_txt.Length)
            txt.Focus()
            Return False
        End If

        ' Assign the value.
        Try
            result = Integer.Parse(txt.Text)
        Catch ex As Exception
            MessageBox.Show("Błąd w " & field_name & "." & _
                vbCrLf & ex.Message)
            txt.Select(0, num_items_txt.Length)
            txt.Focus()
            Return False
        End Try

        ' Sprawdzenie czy podana wartość mieści się w przedziale min_value-max_value.
        If result < min_value Or result > max_value Then
            MessageBox.Show(field_name & " musi należeć do przedziału " & _
                min_value.ToString & "-" & max_value.ToString & ".")
            txt.Select(0, num_items_txt.Length)
            txt.Focus()
            Return False
        End If

        ' Wartość jest prawidłowa.
        Return True
    End Function

    ' Walidacja wartości.
    Private Sub btnValidate_Click() Handles btnValidate.Click
        Dim the_value As Integer

        ' Sprawdzenie czy wartość jest prawidłowa.
        If Not IsValidInteger(the_value, txtValue, "Wartość", 1, 10) Then Exit Sub

        ' Tu powinien być inny kod przetwarzający.
        ' ...
        MessageBox.Show("OK")
    End Sub
End Class
