﻿' Wyłączenie opcji Option Infer powoduje błąd wykonywania.
' Option Strict On      Musi być wyłączona dla rozluźnionego delegatu btnAdd_Click().
Option Explicit On

Public Class Form1
    Private Sub btnAdd_Click() Handles btnAdd.Click
        ' A i B.
        Dim A As Integer = Integer.Parse(txtA.Text)
        Dim B As Integer = Integer.Parse(txtB.Text)

        ' Wywołanie funkcji lambda do obliczenia wyniku.
        txtResult1.Text = (Function(i1 As Integer, i2 As Integer) i1 + i2)(A, B).ToString

        ' Wywołanie podprocedury Calculate z przekazaniem do niej funkcji lambda.
        Dim plus = Function(i1 As Integer, i2 As Integer) i1 + i2
        txtResult2.Text = Calculate(plus, A, B)

        ' Wywołanie podprocedury Calculate z przekazaniem jej funkcji inline lambda.
        txtResult3.Text = Calculate( _
            Function(i1 As Integer, i2 As Integer) i1 + i2, _
            A, B)
    End Sub

    ' Zastosowanie funkcji do dwóch wartości.
    Private Function Calculate(ByVal F As Func(Of Integer, Integer, Integer), ByVal A As Integer, ByVal B As Integer) As String
        ' Wywołanie F, aby obliczyć wynik.
        Return F(A, B).ToString
    End Function
End Class
