﻿Imports System.Windows.Forms
Imports System.IO

Public Class MDIParent1
    ' Make a new window.
    Private Sub ShowNewForm() Handles mnuFileNew.Click, toolNew.Click, mnuWinNew.Click
        Dim frm As New Form1
        frm.MdiParent = Me
        frm.Show()
    End Sub

    ' Open a file.
    Private Sub OpenFile() Handles mnuFileOpen.Click, toolOpen.Click
        Dim dlgOpen As New OpenFileDialog
        If dlgOpen.ShowDialog(Me) = Windows.Forms.DialogResult.OK Then
            Dim frm As New Form1
            frm.LoadFile(dlgOpen.FileName, Me)
            frm.Show()
        End If
    End Sub

    ' Exit.
    Private Sub mnuFileExit_Click() Handles mnuFileExit.Click
        Me.Close()
    End Sub

    ' Toggle the toolbar's visibility.
    Private Sub mnuViewToolbar_Click() Handles mnuViewToolbar.Click
        Me.ToolStrip.Visible = mnuViewToolbar.Checked
    End Sub

    ' Toggle the statu bar's visibility.
    Private Sub mnuViewStatusBar_Click() Handles mnuViewStatusBar.Click
        Me.StatusStrip.Visible = mnuViewStatusBar.Checked
    End Sub

    ' Arrange children.
    Private Sub mnuWinCascade_Click() Handles mnuWinCascade.Click
        Me.LayoutMdi(MdiLayout.Cascade)
    End Sub

    Private Sub mnuWinTileVertical_Click() Handles mnuWinTileVertical.Click
        Me.LayoutMdi(MdiLayout.TileVertical)
    End Sub

    Private Sub mnuWinTileHorizontal_Click() Handles mnuWinTileHorizontal.Click
        Me.LayoutMdi(MdiLayout.TileHorizontal)
    End Sub

    Private Sub mnuWinArrangeIcons_Click() Handles mnuWinArrangeIcons.Click
        Me.LayoutMdi(MdiLayout.ArrangeIcons)
    End Sub

    Private Sub mnuWinMinimizeAll_Click() Handles mnuWinMinimizeAll.Click
        For Each frm As Form In Me.MdiChildren
            frm.WindowState = FormWindowState.Minimized
        Next frm
    End Sub

    Private Sub mnuWinRestoreAll_Click() Handles mnuWinRestoreAll.Click
        For Each frm As Form In Me.MdiChildren
            frm.WindowState = FormWindowState.Normal
        Next frm
    End Sub

    Private Sub mnuWinMaximizeAll_Click() Handles mnuWinMaximizeAll.Click
        For Each frm As Form In Me.MdiChildren
            frm.WindowState = FormWindowState.Maximized
        Next frm
    End Sub

    Private Sub mnuWinCloseAll_Click() Handles mnuWinCloseAll.Click
        For Each frm As Form In Me.MdiChildren
            frm.Close()
        Next
    End Sub
End Class
