﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        Me.SetStyle(ControlStyles.AllPaintingInWmPaint Or ControlStyles.ResizeRedraw, True)
        Me.UpdateStyles()
    End Sub

    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        Dim txt As String = "Trzy różowe świnki"
        Dim layout_rect As New RectangleF(0, 0, _
            Me.ClientSize.Width, Me.ClientSize.Height)
        e.Graphics.TextRenderingHint = System.Drawing.Text.TextRenderingHint.AntiAliasGridFit

        Using the_font As New Font("Times New Roman", 50, _
            FontStyle.Bold Or FontStyle.Italic, GraphicsUnit.Pixel)
            '    Using the_font As New Font("Times New Roman", 50, _
            '       FontStyle.Bold, GraphicsUnit.Pixel)

            Using string_format As New StringFormat
                string_format.LineAlignment = StringAlignment.Center
                string_format.Alignment = StringAlignment.Center

                ' Definiuje tablicę obiektów CharacterRange,
                ' po jednym dla każdego znaku.
                Dim character_ranges(txt.Length - 1) As CharacterRange
                For i As Integer = 0 To txt.Length - 1
                    character_ranges(i) = New CharacterRange(i, 1)
                Next i

                ' Ustawia przedziały w obiekcie StringFormat.
                string_format.SetMeasurableCharacterRanges(character_ranges)

                ' Pobiera regiony zakresów znaków.
                Dim character_regions() As Region = _
                    e.Graphics.MeasureCharacterRanges(txt, _
                    the_font, layout_rect, string_format)

                ' Rysuje granice każdego regionu.
                For Each rgn As Region In character_regions
                    ' Konwersja regionu na prostokąt.
                    Dim character_bounds As RectangleF = rgn.GetBounds(e.Graphics)
                    Dim character_rect As Rectangle = _
                        Rectangle.Round(character_bounds)

                    ' Rysuje granice.
                    e.Graphics.DrawRectangle(Pens.Gray, character_rect)
                Next rgn

                ' Rysuje tekst.
                e.Graphics.DrawString(txt, the_font, Brushes.Black, _
                    layout_rect, string_format)
            End Using ' string_format
        End Using ' the_font
    End Sub
End Class
