﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        Dim dict As New EmployeeDictionary
        dict.Add("123-45-6789", New Employee("Al", "Ankh"))
        dict.Add("111-22-3333", New Employee("Bertie", "Bithoin"))
        dict.Add("365-76-5476", New Employee("Carl", "Catabalpas"))
        dict.Add("832-77-6847", New Employee("Dee", "Divers"))

        Dim txt As String = ""
        txt &= dict.Item("123-45-6789").ToString & vbCrLf
        txt &= dict.Item("111-22-3333").ToString & vbCrLf
        txt &= dict.Item("365-76-5476").ToString & vbCrLf
        txt &= dict.Item("832-77-6847").ToString & vbCrLf

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub
End Class

Public Class Employee
    Private m_FirstName As String
    Private m_LastName As String
    Public Sub New(ByVal first_name As String, ByVal last_name As String)
        m_FirstName = first_name
        m_LastName = last_name
    End Sub
    Public Overrides Function ToString() As String
        Return m_FirstName & " " & m_LastName
    End Function
End Class

Public Class EmployeeDictionary
    Inherits System.Collections.DictionaryBase

    ' Dodaje wpis do słownika.
    Public Sub Add(ByVal new_key As String, ByVal new_employee As Employee)
        Dictionary.Add(new_key, new_employee)
    End Sub

    ' Zwraca obiekt mający określony klucz.
    Default Public Property Item(ByVal key As String) As Employee
        Get
            Return DirectCast(Dictionary.Item(key), Employee)
        End Get
        Set(ByVal Value As Employee)
            Dictionary.Item(key) = Value
        End Set
    End Property

    ' Zwraca kolekcję zawierającą klucze ze słownika.
    Public ReadOnly Property Keys() As ICollection
        Get
            Return Dictionary.Keys
        End Get
    End Property

    ' Zwraca kolekcję zawierającą wartości ze słownika.
    Public ReadOnly Property Values() As ICollection
        Get
            Return Dictionary.Values
        End Get
    End Property

    ' Zwraca True, jeśli słownik zawiera tego pracownika.
    Public Function Contains(ByVal key As String) As Boolean
        Return Dictionary.Contains(key)
    End Function

    ' Usuwa ten wpis.
    Public Sub Remove(ByVal key As String)
        Dictionary.Remove(key)
    End Sub
End Class
