﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        Dim customers As New List(Of Person)
        customers.Add(New Person() With {.FirstName = "Dan", .LastName = "Dump", .CustId = 1})
        customers.Add(New Person() With {.FirstName = "Frank", .LastName = "Fix", .CustId = 4})
        customers.Add(New Person() With {.FirstName = "Ben", .LastName = "Best", .CustId = 2})
        customers.Add(New Person() With {.FirstName = "Ann", .LastName = "Archer", .CustId = 5})
        customers.Add(New Person() With {.FirstName = "Edna", .LastName = "Ever", .CustId = 3})
        customers.Add(New Person() With {.FirstName = "Carly", .LastName = "Cant", .CustId = 6})

        Dim orders As New List(Of Order)
        orders.Add(New Order() With {.CustId = 2, .OrderId = 100})
        orders.Add(New Order() With {.CustId = 1, .OrderId = 101})
        orders.Add(New Order() With {.CustId = 3, .OrderId = 102})
        orders.Add(New Order() With {.CustId = 1, .OrderId = 103})
        orders.Add(New Order() With {.CustId = 1, .OrderId = 104})
        orders.Add(New Order() With {.CustId = 2, .OrderId = 105})
        orders.Add(New Order() With {.CustId = 2, .OrderId = 106})
        orders.Add(New Order() With {.CustId = 3, .OrderId = 107})

        Dim order_items As New List(Of OrderItem)
        order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Apple"})
        order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Cherry"})
        order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Ash"})
        order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Cat"})
        order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Beech"})
        order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Bat"})
        order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Banana"})
        order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Dog"})
        order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Choke Cherry"})
        order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Ape"})

        Dim txt As String = ""

        txt &= "Składnia LINQ:" & vbCrLf
        Dim q1 = From per In customers _
            Where per.FirstName.Length() >= per.LastName.Length() _
            Order By per.CustId _
            Select per
        For Each per As Person In q1
            txt &= Space$(4) & per.ToString() & vbCrLf
        Next per
        txt &= vbCrLf

        txt &= "Delegat lambda:" & vbCrLf
        Dim FirstNameLonger = Function(per As Person) per.FirstName.Length() >= per.LastName.Length()
        Dim q2 = From per In customers _
            Order By per.CustId _
            Select per
        q2 = q2.Where(FirstNameLonger)
        For Each per As Person In q2
            txt &= Space$(4) & per.ToString() & vbCrLf
        Next per
        txt &= vbCrLf

        txt &= "Lambda inline:" & vbCrLf
        Dim q3 = From per In customers _
            Order By per.CustId _
            Select per
        q3 = q3.Where(Function(per As Person) per.FirstName.Length() >= per.LastName.Length())
        For Each per As Person In q3
            txt &= Space$(4) & per.ToString() & vbCrLf
        Next per

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub
End Class

Public Class Person
    Public FirstName As String
    Public LastName As String
    Public CustId As Integer
    Public Overrides Function ToString() As String
        Return FirstName & " " & LastName & " (" & CustId & ")"
    End Function
End Class

Public Class Order
    Public CustId As Integer
    Public OrderDate As Date
    Public OrderId As Integer
    Public Overrides Function ToString() As String
        Return "CustId: " & CustId & ", OrderId: " & OrderId & ", Date: " & OrderDate
    End Function
End Class

Public Class OrderItem
    Public OrderId As Integer
    Public Description As String
    Public Overrides Function ToString() As String
        Return "OrderId: " & OrderId & ", Opis: " & Description
    End Function
End Class
