﻿Public Class Form1
    Private all_customers As New List(Of Customer)
    Private all_orders As New List(Of Order)
    Private all_orderitems As New List(Of OrderItem)

    Private Sub Form1_Load() Handles MyBase.Load
        all_customers.Add(New GoodCustomer() With {.FirstName = "Bob", .LastName = "Bend", .CustId = 200, .AccountBalance = 30, .PaymentLate = True})
        all_customers.Add(New Customer() With {.FirstName = "Dan", .LastName = "Dent", .CustId = 400, .AccountBalance = -95, .PaymentLate = True})
        all_customers.Add(New GoodCustomer() With {.FirstName = "Cindy", .LastName = "Cart", .CustId = 300, .AccountBalance = -110, .PaymentLate = True})
        all_customers.Add(New Customer() With {.FirstName = "Alice", .LastName = "Arch", .CustId = 100, .AccountBalance = 10, .PaymentLate = True})

        all_orders.Add(New Order() With {.CustId = 100, .OrderId = 1001, .OrderDate = #4/1/2008#})
        all_orders.Add(New Order() With {.CustId = 100, .OrderId = 1002, .OrderDate = #4/5/2008#})
        all_orders.Add(New Order() With {.CustId = 200, .OrderId = 1003, .OrderDate = #4/12/2008#})
        all_orders.Add(New Order() With {.CustId = 200, .OrderId = 1004, .OrderDate = #4/19/2008#})
        all_orders.Add(New Order() With {.CustId = 300, .OrderId = 1005, .OrderDate = #4/5/2008#})
        all_orders.Add(New Order() With {.CustId = 400, .OrderId = 1006, .OrderDate = #4/19/2008#})
        all_orders.Add(New Order() With {.CustId = 400, .OrderId = 1007, .OrderDate = #4/5/2008#})

        all_orderitems.Add(New OrderItem() With {.OrderId = 1001, .ItemName = "Pencils, dozen", .UnitPrice = 0.75, .Quantity = 3})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1001, .ItemName = "Notepad", .UnitPrice = 1.15, .Quantity = 12})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1001, .ItemName = "Soda, 12-pack", .UnitPrice = 2.75, .Quantity = 4})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1002, .ItemName = "Candy bar", .UnitPrice = 0.65, .Quantity = 144})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1002, .ItemName = "Laptop computer", .UnitPrice = 1445.93, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1003, .ItemName = "Copy paper, ream", .UnitPrice = 2.18, .Quantity = 10})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1004, .ItemName = "Programming book", .UnitPrice = 27.95, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1005, .ItemName = "Pencils, dozen", .UnitPrice = 0.75, .Quantity = 4})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1005, .ItemName = "Dry erase markers, 5-pack", .UnitPrice = 3.8, .Quantity = 2})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1006, .ItemName = "Fancy mouse", .UnitPrice = 42.57, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1007, .ItemName = "12TB flash drive", .UnitPrice = 107.75, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1007, .ItemName = "Pencils, dozen", .UnitPrice = 0.75, .Quantity = 1})

        Dim txt As String = ""

        txt &= "From i Where" & vbCrLf
        Dim q1 = _
            From cust As Customer In all_customers, ord In all_orders _
            Where cust.CustId = ord.CustId _
            Order By cust.CustId, ord.OrderId
        For Each obj In q1
            txt &= Space$(4) & obj.cust.ToString() & vbTab & obj.ord.ToString() & vbCrLf
        Next obj
        txt &= vbCrLf

        txt &= "From i Join" & vbCrLf
        Dim q2 = _
            From cust As Customer In all_customers _
                Join ord In all_orders _
                On cust.CustId Equals ord.CustId _
            Order By cust.CustId, ord.OrderId
        For Each obj In q2
            txt &= Space$(4) & obj.cust.ToString() & vbTab & obj.ord.ToString() & vbCrLf
        Next obj
        txt &= vbCrLf

        txt &= "Group Join" & vbCrLf
        Dim q3 = _
            From cust In all_customers _
                Group Join ord In all_orders _
                On cust.CustId Equals ord.CustId _
                Into CustomerOrders = Group _
            Order By cust.CustId
        For Each obj In q3
            ' Wyświetlenie klienta.
            txt &= Space$(4) & obj.cust.ToString() & vbCrLf

            ' Wyświetlenie zamówień klienta.
            For Each ord In obj.CustomerOrders
                txt &= Space$(8) & "OrderId: " & ord.OrderId & ", Data: " & ord.OrderDate & vbCrLf
            Next ord
        Next obj
        txt &= vbCrLf

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub
End Class

Public Class Customer
    Public FirstName As String
    Public LastName As String
    Public CustId As Integer
    Public AccountBalance As Decimal
    Public PaymentLate As Boolean
    Public Overrides Function ToString() As String
        Return FirstName & " " & LastName & " - " & CustId & " " & FormatCurrency(AccountBalance)
    End Function
End Class

Public Class GoodCustomer
    Inherits Customer
End Class

Public Class Order
    Public OrderDate As Date
    Public OrderId As Integer
    Public CustId As Integer
    Public Overrides Function ToString() As String
        Return "CustId: " & CustId & ", OrderId: " & OrderId & ", OrderDate: " & OrderDate
    End Function
End Class

Public Class OrderItem
    Public OrderId As Integer
    Public ItemName As String
    Public Quantity As Integer
    Public UnitPrice As Decimal
End Class
