﻿Public Class Form1
    Private WithEvents m_CurrencyManager As CurrencyManager

    Private Sub Form1_Load() Handles MyBase.Load
        'TODO: This line of code loads data into the 'BooksDataSet.Books' table. You can move, or remove it, as needed.
        Me.BooksTableAdapter.Fill(Me.BooksDataSet.Books)

        ' Obiekt CurrencyManager.
        m_CurrencyManager = DirectCast(Me.BindingContext( _
            BooksBindingSource), CurrencyManager)

        ' Wyświetla numer rekordu.
        m_CurrencyManager_PositionChanged()
    End Sub

    ' Przechodzi do poprzedniego rekordu.
    Private Sub btnPrev_Click() Handles btnPrev.Click
        If m_CurrencyManager.Position = 0 Then
            Beep()
        Else
            m_CurrencyManager.Position -= 1
        End If
    End Sub

    ' Przechodzi do kolejnego rekordu.
    Private Sub btnNext_Click() Handles btnNext.Click
        If m_CurrencyManager.Position >= m_CurrencyManager.Count - 1 Then
            Beep()
        Else
            m_CurrencyManager.Position += 1
        End If
    End Sub

    Private Sub m_CurrencyManager_PositionChanged() Handles m_CurrencyManager.PositionChanged
        lblPosition.Text = _
            (m_CurrencyManager.Position + 1) & " of " & _
            m_CurrencyManager.Count
    End Sub

    ' Przechodzi do pierwszego rekordu.
    Private Sub btnFirst_Click() Handles btnFirst.Click
        m_CurrencyManager.Position = 0
    End Sub

    ' Przechodzi do ostatniego rekordu.
    Private Sub btnLast_Click() Handles btnLast.Click
        m_CurrencyManager.Position = m_CurrencyManager.Count - 1
    End Sub

    ' Dodaje rekord.
    Private Sub btnAdd_Click() Handles btnAdd.Click
        m_CurrencyManager.AddNew()
        txtTitle.Focus()
    End Sub

    ' Usuwa bieżący rekord.
    Private Sub btnDelete_Click() Handles btnDelete.Click
        If MessageBox.Show("Czy na pewno chcesz usunąć ten rekord?", _
            "Potwierdzenie", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = Windows.Forms.DialogResult.Yes _
        Then
            m_CurrencyManager.RemoveAt(m_CurrencyManager.Position)
        End If
    End Sub
End Class
