﻿Class Window1 
    Private m_Grid As Grid
    Private WithEvents lblResult As Label
    Private WithEvents btnNum0, btnNum1, btnNum2, btnNum3, btnNum4, btnNum5, btnNum6, btnNum7, btnNum8, btnNum9 As Button
    Private WithEvents btnCE, btnC, btnEquals, btnDecimal As Button
    Private WithEvents btnPlus, btnMinus, btnTimes, btnDivide, btnPlusMinus As Button

#Region "BuildUI"
    Private Sub Window1_Loaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles Me.Loaded
        ' Get the grid.
        m_Grid = DirectCast(Me.Content, Grid)
        m_Grid.Margin = New Thickness(0, 0, 0, 0)
        'm_Grid.ShowGridLines = True

        ' Define resources.
        Dim br_result As New LinearGradientBrush( _
            Colors.LightBlue, _
            Colors.AliceBlue, _
            New Point(0, 0), _
            New Point(1, 1))

        Dim br_clear As New RadialGradientBrush( _
            Colors.AliceBlue, Colors.Blue)
        br_clear.Center = New Point(0.5, 0.5)
        br_clear.RadiusX = 1
        br_clear.RadiusY = 1

        Dim br_op As New RadialGradientBrush( _
            Colors.Lime, Colors.Green)
        br_op.Center = New Point(0.5, 0.5)
        br_op.RadiusX = 1
        br_op.RadiusY = 1

        Dim br_digit As New RadialGradientBrush( _
            Colors.Yellow, Colors.Orange)
        br_digit.Center = New Point(0.5, 0.5)
        br_digit.RadiusX = 1
        br_digit.RadiusY = 1

        ' Define styles.
        Dim style_clear As New Style()
        style_clear.Setters.Add(New Setter(Control.BackgroundProperty, br_clear))

        Dim style_op As New Style()
        style_op.Setters.Add(New Setter(Control.BackgroundProperty, br_op))

        Dim style_digit As New Style()
        style_digit.Setters.Add(New Setter(Control.BackgroundProperty, br_digit))

        ' Add rows and columns.
        AddRow(m_Grid, New GridLength(17, GridUnitType.Star))
        AddRow(m_Grid, New GridLength(22, GridUnitType.Star))
        AddRow(m_Grid, New GridLength(17, GridUnitType.Star))
        AddRow(m_Grid, New GridLength(17, GridUnitType.Star))
        AddRow(m_Grid, New GridLength(17, GridUnitType.Star))
        AddRow(m_Grid, New GridLength(17, GridUnitType.Star))

        AddCol(m_Grid, New GridLength(25, GridUnitType.Star))
        AddCol(m_Grid, New GridLength(25, GridUnitType.Star))
        AddCol(m_Grid, New GridLength(25, GridUnitType.Star))
        AddCol(m_Grid, New GridLength(25, GridUnitType.Star))

        ' Add the display label.
        lblResult = New Label()
        lblResult.Name = "lblResult"
        lblResult.Background = br_result
        lblResult.Content = "0"
        lblResult.Margin = New Thickness(2, 2, 2, 2)
        lblResult.HorizontalAlignment = Windows.HorizontalAlignment.Stretch
        lblResult.HorizontalContentAlignment = Windows.HorizontalAlignment.Right
        lblResult.VerticalAlignment = Windows.VerticalAlignment.Center
        lblResult.SetValue(Grid.RowProperty, 0)
        lblResult.SetValue(Grid.ColumnProperty, 0)
        lblResult.SetValue(Grid.ColumnSpanProperty, 4)
        m_Grid.Children.Add(lblResult)

        ' Add buttons.
        ' Row 1.
        btnCE = AddButton(m_Grid, 1, 0, "CE", New Thickness(2, 20, 2, 2), style_clear)
        btnC = AddButton(m_Grid, 1, 1, "C", New Thickness(2, 20, 2, 2), style_clear)
        btnEquals = AddButton(m_Grid, 1, 3, "=", New Thickness(2, 20, 2, 2), style_clear)

        ' Row 2.
        btnNum7 = AddButton(m_Grid, 2, 0, "7", New Thickness(2, 2, 2, 2), style_digit)
        btnNum8 = AddButton(m_Grid, 2, 1, "8", New Thickness(2, 2, 2, 2), style_digit)
        btnNum9 = AddButton(m_Grid, 2, 2, "9", New Thickness(2, 2, 2, 2), style_digit)
        btnDivide = AddButton(m_Grid, 2, 3, "/", New Thickness(2, 2, 2, 2), style_op)

        ' Row 3.
        btnNum4 = AddButton(m_Grid, 3, 0, "4", New Thickness(2, 2, 2, 2), style_digit)
        btnNum5 = AddButton(m_Grid, 3, 1, "5", New Thickness(2, 2, 2, 2), style_digit)
        btnNum6 = AddButton(m_Grid, 3, 2, "6", New Thickness(2, 2, 2, 2), style_digit)
        btnTimes = AddButton(m_Grid, 3, 3, "*", New Thickness(2, 2, 2, 2), style_op)

        ' Row 4.
        btnNum1 = AddButton(m_Grid, 4, 0, "1", New Thickness(2, 2, 2, 2), style_digit)
        btnNum2 = AddButton(m_Grid, 4, 1, "2", New Thickness(2, 2, 2, 2), style_digit)
        btnNum3 = AddButton(m_Grid, 4, 2, "3", New Thickness(2, 2, 2, 2), style_digit)
        btnMinus = AddButton(m_Grid, 4, 3, "-", New Thickness(2, 2, 2, 2), style_op)

        ' Row 5.
        btnNum0 = AddButton(m_Grid, 5, 0, "0", New Thickness(2, 2, 2, 2), style_digit)
        btnPlusMinus = AddButton(m_Grid, 5, 1, "+/-", New Thickness(2, 2, 2, 2), style_digit)
        btnDecimal = AddButton(m_Grid, 5, 2, ".", New Thickness(2, 2, 2, 2), style_digit)
        btnPlus = AddButton(m_Grid, 5, 3, "+", New Thickness(2, 2, 2, 2), style_op)
    End Sub

    ' Add a row of the indicated height to the grid.
    Private Sub AddRow(ByVal my_grid As System.Windows.Controls.Grid, ByVal height As GridLength)
        Dim row_def As New RowDefinition()
        row_def.Height = height
        my_grid.RowDefinitions.Add(row_def)
    End Sub

    ' Add a column of the indicated width to the grid.
    Private Sub AddCol(ByVal my_grid As System.Windows.Controls.Grid, ByVal width As GridLength)
        Dim col_def As New ColumnDefinition()
        col_def.Width = width

        my_grid.ColumnDefinitions.Add(col_def)
    End Sub

    ' Add a button with the given caption to the
    ' grid at the indicated row and column.
    Private Function AddButton(ByVal my_grid As Grid, ByVal r As Integer, ByVal c As Integer, ByVal text As String, ByVal margin As Thickness, ByVal btn_style As Style) As Button
        Dim btn As New Button()
        btn.Content = text
        btn.SetValue(Grid.RowProperty, r)
        btn.SetValue(Grid.ColumnProperty, c)
        btn.SetValue(Grid.MarginProperty, margin)
        btn.Focusable = False
        btn.Style = btn_style

        my_grid.Children.Add(btn)

        Return btn
    End Function
#End Region ' BuildUI

#Region "Variables"
    ' The operator we are using.
    Private Enum Operators
        opNone
        opTimes
        opDivide
        opPlus
        opMinus
    End Enum
    Private m_Operator As Operators = Operators.opNone

    ' The first operand.
    Private m_SavedValue As Double = 0

    ' True when we need to start a new value.
    ' This is set when we click an operator.
    Private m_NewValue As Boolean = True

    ' True if we press C (used to know if we pressed CC).
    Private m_JustCleared As Boolean = False
#End Region ' Variables

#Region "Buttons"
    ' The user clicked a digit.
    Private Sub btnDigit_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles btnNum0.Click, btnNum1.Click, btnNum2.Click, btnNum3.Click, btnNum4.Click, btnNum5.Click, btnNum6.Click, btnNum7.Click, btnNum8.Click, btnNum9.Click
        Dim btn As Button = DirectCast(sender, Button)
        ProcessDigit(btn.Content.ToString())
    End Sub

    ' The user clicked the decimal point button.
    Private Sub btnDecimal_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles btnDecimal.Click
        ProcessDecimal()
    End Sub

    ' The user clicked CE.
    ' Clear just the current entry.
    Private Sub ClickCE(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs)
        ProcessCE()
    End Sub

    ' The user clicked C.
    ' Clear the current value, saved value, and operator.
    Private Sub btnC_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles btnC.Click
        ProcessC()
    End Sub

    ' Calculate a result.
    Private Sub btnEquals_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles btnEquals.Click
        ProcessEquals()
    End Sub

    ' Store an operator other than equals.
    Private Sub btnOperator_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles btnPlus.Click, btnMinus.Click, btnTimes.Click, btnDivide.Click
        ' Process the operator.
        Dim btn As Button = DirectCast(sender, Button)
        Select Case btn.Content.ToString()
            Case "+"
                ProcessOperator(Operators.opPlus)
            Case "-"
                ProcessOperator(Operators.opMinus)
            Case "*"
                ProcessOperator(Operators.opTimes)
            Case "/"
                ProcessOperator(Operators.opDivide)
        End Select
    End Sub

    ' The user clicked "+/-".
    Private Sub btnPlusMinus_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles btnPlusMinus.Click
        ProcessPlusMinus()
    End Sub
#End Region ' Buttons

#Region "Keys"
    ' Process Delete, Backspace, and Enter.
    Private Sub Window1_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Input.KeyEventArgs) Handles Me.KeyDown
        Select Case e.Key
            Case Key.Delete, Key.Back
                DeleteCharacter()
            Case Key.Enter
                ProcessEquals()
        End Select
    End Sub

    ' Process digits, decimal point, and operators.
    Private Sub Window1_TextInput(ByVal sender As Object, ByVal e As System.Windows.Input.TextCompositionEventArgs) Handles Me.TextInput
        Select Case e.Text
            Case "0" To "9"         ' Digits.
                ProcessDigit(e.Text)

            Case "."                ' Decimal point.
                ProcessDecimal()

            Case "C", "c"           ' C.
                If m_JustCleared Then
                    ' Clear all.
                    ProcessC()
                Else
                    ' Clear entry.
                    ProcessCE()
                End If

            Case "+"                ' Operators.
                ProcessOperator(Operators.opPlus)
            Case "-"
                ProcessOperator(Operators.opMinus)
            Case "*"
                ProcessOperator(Operators.opTimes)
            Case "/"
                ProcessOperator(Operators.opDivide)

            Case "="
                ProcessOperator(Operators.opNone)
        End Select
    End Sub
#End Region ' Keys

#Region "Process User Actions"
    ' Remove the last character.
    Private Sub DeleteCharacter()
        ' Remove the sign.
        Dim txt As String = lblResult.Content.ToString()
        Dim sign As String = ""
        If txt.StartsWith("-") Then
            sign = "-"
            txt = txt.Substring(1)
        End If

        ' Remove the final digit.
        txt = txt.Substring(0, txt.Length - 1)

        ' Replace the sign and clean it up.
        txt = sign & txt
        lblResult.Content = CleanResult(txt)

        m_JustCleared = False
    End Sub

    ' Add a digit to the output.
    Private Sub ProcessDigit(ByVal digit As String)
        ' If this is a new value, start with nothing.
        Dim txt As String = ""
        If Not m_NewValue Then
            txt = lblResult.Content.ToString()
        End If

        ' Add the digit and clean it up.
        lblResult.Content = CleanResult(txt & digit)

        m_JustCleared = False
        m_NewValue = False
    End Sub

    ' Add a decimal point to the output.
    Private Sub ProcessDecimal()
        Dim txt As String = lblResult.Content.ToString()
        If txt.Contains(".") Then
            Beep()
        Else
            ProcessDigit(".")
        End If
    End Sub

    ' Remove leading zeros.
    Private Function CleanResult(ByVal txt As String) As String
        ' Remove the sign.
        Dim sign As String = ""
        If txt.StartsWith("-") Then
            txt = txt.Substring(1)
            sign = "-"
        End If

        ' Remove leading zeros.
        Do While txt.StartsWith("0")
            txt = txt.Substring(1)
        Loop

        ' Add leading zero if it starts with
        ' a decimal point or has zero length.
        If txt.StartsWith(".") OrElse _
            txt.Length = 0 _
        Then
            txt = "0" & txt
        End If

        ' Add the sign and return.
        Return sign & txt
    End Function

    ' The user clicked =.
    Private Sub ProcessEquals()
        Dim txt As String = lblResult.Content.ToString()
        Dim new_value As Double = Double.Parse(txt)

        Select Case m_Operator
            Case Operators.opNone
                m_SavedValue = new_value
            Case Operators.opPlus
                m_SavedValue = m_SavedValue + new_value
            Case Operators.opMinus
                m_SavedValue = m_SavedValue - new_value
            Case Operators.opTimes
                m_SavedValue = m_SavedValue * new_value
            Case Operators.opDivide
                m_SavedValue = m_SavedValue / new_value
        End Select

        m_Operator = Operators.opNone

        ' Display the result.
        lblResult.Content = m_SavedValue.ToString

        ' Strobe the result to provide visual feedback.
        StrobeResult()

        ' Start a new value.
        m_NewValue = True

        ' We did not just clear.
        m_JustCleared = False
    End Sub

    ' Process an operator.
    Private Sub ProcessOperator(ByVal op As Operators)
        ' Perform the previous operation.
        ' This also:
        '   Strobes the result
        '   Sets m_NewValue = True
        '   Sets m_JustCleared = False
        ProcessEquals()

        ' Remember this operation.
        m_Operator = op
    End Sub

    Private Sub ProcessPlusMinus()
        Dim txt As String = lblResult.Content.ToString()
        If txt.StartsWith("-") Then
            txt = txt.Substring(1)
        Else
            txt = "-" & txt
        End If

        lblResult.Content = txt

        m_NewValue = False
        m_JustCleared = False
    End Sub

    ' The user clicked CE.
    Private Sub ProcessCE()
        lblResult.Content = "0"
        m_NewValue = True
    End Sub

    ' The user clicked C.
    Private Sub ProcessC()
        m_SavedValue = 0
        m_Operator = Operators.opNone

        ProcessCE()
    End Sub
#End Region ' Process User Actions

    ' Play a click sound to give some feedback.
    Private Sub StrobeResult()
        ' Animate the button.
        ' Register the button's name with the window.
        Me.RegisterName(lblResult.Name, lblResult)

        ' Make the DoubleAnimation.
        Dim opacity_a As New Animation.DoubleAnimation()
        opacity_a.From = 1.0
        opacity_a.To = 0.0
        opacity_a.Duration = _
            New Duration(TimeSpan.FromSeconds(0.2))
        opacity_a.FillBehavior = Animation.FillBehavior.Stop

        ' We are animating the lblResult
        ' Control's Opacity property.
        Animation.Storyboard.SetTargetName( _
            opacity_a, lblResult.Name)
        Animation.Storyboard.SetTargetProperty( _
            opacity_a, New PropertyPath(Button.OpacityProperty))

        ' Add the animation to a StoryBoard.
        Dim sb As New Animation.Storyboard()
        sb.Children.Add(opacity_a)

        ' Begin the StoryBoard.
        sb.Begin(Me)

        ' Play a click sound.
        My.Computer.Audio.Play( _
            My.Resources.Windows_Navigation_Start, _
            AudioPlayMode.Background)
    End Sub
End Class
