﻿Public Class Form1
    ' Walidacja zawartości kontrolki TextBox.
    Private Sub txtNumber_Validating(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles txtNumber1.Validating, txtNumber2.Validating, txtNumber3.Validating
        ' Walidacja wartości tej kontrolki.
        ValidateFiveDigits(DirectCast(sender, TextBox))
    End Sub

    ' Sprawdzenie czy kontrolka ta zawiera pięć cyfr.
    Private Sub ValidateFiveDigits(ByVal text_box As TextBox)
        ' Sprawdzenie czy dane są poprawne.
        If (text_box.Text.Length <> 0) And _
            Not (text_box.Text Like "#####") _
        Then
            ' Niepoprawne. Błąd.
            errBadDigits.SetError(text_box, _
                text_box.Name & " musi zawierać dokładnie pięć cyfr")
        Else
            ' Poprawne. Czyszczenie błędu.
            errBadDigits.SetError(text_box, "")
        End If
    End Sub

    ' Sprawdzenie czy jakieś pola mają komunikaty o błędach.
    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        ' Założenie, że anulujemy zamykanie.
        e.Cancel = True

        ' Sprawdzenie czy są błędy.
        If IsInvalidField(txtNumber1) Then Exit Sub
        If IsInvalidField(txtNumber3) Then Exit Sub

        ' Jeśli dotarliśmy tutaj, dane są w porządku.
        e.Cancel = False
    End Sub

    ' Jeśli do tej kontrolki jest przypisany komunikat o błędzie,
    ' zostanie on wyświetlony, kontrolka zostanie aktywowana,
    ' i zostanie zwrócona wartość True.
    Private Function IsInvalidField(ByVal ctl As Control) As Boolean
        ' Sprawdzenie czy z kontrolką jest skojarzony komunikat o błędzie.
        If errBadDigits.GetError(ctl).Length = 0 Then
            ' Brak komunikatu o błędzie.
            Return False
        Else
            ' Jest komunikat o błędzie.
            ' Wyświetlenie tego komunikatu.
            MessageBox.Show(errBadDigits.GetError(ctl))

            ' Aktywowanie kontrolki.
            ctl.Focus()
            Return True
        End If
    End Function
End Class
