﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Tworzy nagłówki kolumn ListView.
        ListViewMakeColumnHeaders(lvwBooks, _
            "Title", HorizontalAlignment.Left, 120, _
            "URL", HorizontalAlignment.Left, 120, _
            "ISBN", HorizontalAlignment.Left, 90, _
            "Picture", HorizontalAlignment.Left, 120, _
            "Pages", HorizontalAlignment.Right, 50, _
            "Year", HorizontalAlignment.Right, 40)

        ListViewMakeRow(lvwBooks, 0, _
            "Visual Basic and XML", _
            "http://www.vb-helper.com/xml.htm", _
            "0-471-12060-X", _
            "http://www.vb-helper.com/xml.jpg", _
            "503", _
            "2002")
        ListViewMakeRow(lvwBooks, 0, _
            "Visual Basic Graphics Programming, 2e", _
            "http://www.vb-helper.com/vbgp.htm", _
            "0-471-35599-2", _
            "http://www.vb-helper.com/vbgp.jpg", _
            "712", _
            "2000")
        ListViewMakeRow(lvwBooks, 0, _
            "Ready-to-Run Visual Basic Algorithms", _
            "http://www.vb-helper.com/vba.htm", _
            "0-471-24268-3", _
            "http://www.vb-helper.com/vba.jpg", _
            "395", _
            "1998")

        ListViewSizeColumns(lvwBooks, True)
        Text = "RunTimeListView (" & lvwBooks.View.ToString & ")"
        lvwBooks.View = View.Details
        CheckMenus()
    End Sub

    ' Tworzy nagłówki kolumny ListView.
    ' Wpisy ParamArray powinny składać się z trzech elementów:
    ' tytułu kolumny, wartości HorizontalAlignment oraz szerokości.
    Private Sub ListViewMakeColumnHeaders(ByVal lvw As ListView, ByVal ParamArray header_info() As Object)
        ' Usuwa istniejące nagłówki.
        lvw.Columns.Clear()

        ' Tworzy nagłówki kolumn.
        For i As Integer = header_info.GetLowerBound(0) To header_info.GetUpperBound(0) Step 3
            Dim col_header As ColumnHeader = lvw.Columns.Add( _
                DirectCast(header_info(i), String), _
                -1, _
                DirectCast(header_info(i + 1), HorizontalAlignment))
            col_header.Width = DirectCast(header_info(i + 2), Integer)
        Next i
    End Sub

    ' Tworzy wiersz ListView.
    Private Sub ListViewMakeRow(ByVal lvw As ListView, ByVal image_index As Integer, ByVal item_title As String, ByVal ParamArray subitem_titles() As String)
        ' Tworzy element.
        Dim new_item As ListViewItem = lvw.Items.Add(item_title)
        new_item.ImageIndex = image_index

        ' Tworzy podelementy.
        For i As Integer = subitem_titles.GetLowerBound(0) To subitem_titles.GetUpperBound(0)
            new_item.SubItems.Add(subitem_titles(i))
        Next i
    End Sub

    ' Ustawia szerokości kolumn na -1, aby pasowały do danych,
    ' -2, aby pasowały do danych i nagłówka.
    Private Sub ListViewSizeColumns(ByVal lvw As ListView, ByVal allow_room_for_header As Boolean)
        Dim new_wid As Integer = -1
        If allow_room_for_header Then new_wid = -2

        ' Ustawia szerokości kolumn.
        For i As Integer = 0 To lvw.Columns.Count - 1
            lvw.Columns(i).Width = new_wid
        Next i
    End Sub

    Private Sub mnuViewDetails_Click() Handles mnuViewDetails.Click
        lvwBooks.View = View.Details
        Text = "RunTimeListView (" & lvwBooks.View.ToString & ")"
        CheckMenus()
    End Sub

    Private Sub mnuViewLargeIcons_Click() Handles mnuViewLargeIcons.Click
        lvwBooks.View = View.LargeIcon
        Text = "RunTimeListView (" & lvwBooks.View.ToString & ")"
        CheckMenus()
    End Sub

    Private Sub mnuViewList_Click() Handles mnuViewList.Click
        lvwBooks.View = View.List
        Text = "RunTimeListView (" & lvwBooks.View.ToString & ")"
        CheckMenus()
    End Sub

    Private Sub mnuViewSmallIcons_Click() Handles mnuViewSmallIcons.Click
        lvwBooks.View = View.SmallIcon
        Text = "RunTimeListView (" & lvwBooks.View.ToString & ")"
        CheckMenus()
    End Sub

    Private Sub mnuViewTile_Click() Handles mnuViewTile.Click
        lvwBooks.View = View.Tile
        Text = "RunTimeListView (" & lvwBooks.View.ToString & ")"
        CheckMenus()
    End Sub

    Private Sub CheckMenus()
        mnuViewDetails.Checked = (lvwBooks.View = View.Details)
        mnuViewLargeIcons.Checked = (lvwBooks.View = View.LargeIcon)
        mnuViewList.Checked = (lvwBooks.View = View.List)
        mnuViewSmallIcons.Checked = (lvwBooks.View = View.SmallIcon)
        mnuViewTile.Checked = (lvwBooks.View = View.Tile)
    End Sub
End Class
