﻿Imports System.Reflection

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Tworzy nagłówki kolumn.
        lvwProperties.View = View.Details
        lvwProperties.Columns.Clear()
        lvwProperties.Columns.Add("Property", 10, _
            HorizontalAlignment.Left)
        lvwProperties.Columns.Add("Type", 10, _
            HorizontalAlignment.Left)
        lvwProperties.Columns.Add("Value", 10, _
            HorizontalAlignment.Left)

        ' Tworzy listę własności.
        ' Zamiast Form1 użyj klasy, którą chcesz zbadać.
        Dim property_value As Object
        Dim properties_info As PropertyInfo() = _
            GetType(Form1).GetProperties()
        lvwProperties.Items.Clear()
        For i As Integer = 0 To properties_info.Length - 1
            With properties_info(i)
                If .GetIndexParameters().Length = 0 Then
                    property_value = .GetValue(Me, Nothing)
                    If property_value Is Nothing Then
                        ListViewMakeRow(lvwProperties, _
                            .Name, _
                            .PropertyType.ToString, _
                            "<Nothing>")
                    Else
                        ListViewMakeRow(lvwProperties, _
                            .Name, _
                            .PropertyType.ToString, _
                            property_value.ToString)
                    End If
                Else
                    ListViewMakeRow(lvwProperties, _
                        .Name, _
                        .PropertyType.ToString, _
                        "<array>")
                End If
            End With
        Next i

        ' Ustawianie odpowiedniego rozmiaru kolumn.
        lvwProperties.Columns(0).Width = -2
        lvwProperties.Columns(1).Width = -2
        lvwProperties.Columns(2).Width = -2
    End Sub

    ' Podprocedura pomocnicza ListViewMakeRow tworzy element i podelementy w kontrolce ListView.
    ' Tworzy wiersz w kontrolce ListView.
    Private Sub ListViewMakeRow(ByVal lvw As ListView, ByVal item_title As String, ByVal ParamArray subitem_titles() As String)
        ' Tworzy element.
        Dim new_item As ListViewItem = lvw.Items.Add(item_title)

        ' Tworzy podelementy.
        For i As Integer = subitem_titles.GetLowerBound(0) To _
            subitem_titles.GetUpperBound(0)
            new_item.SubItems.Add(subitem_titles(i))
        Next i
    End Sub
End Class
