﻿Public Class Form1
    ' Obiekty Bitmap i Graphics, na których będziemy rysować.
    Private m_Bitmap As Bitmap
    Private m_Graphics As Graphics

    ' Do gryzmolenia.
    Private m_Drawing As Boolean
    Private m_X As Integer
    Private m_Y As Integer

    ' Tworzy początkowy pusty obraz.
    Private Sub Form1_Load() Handles MyBase.Load
        MakeNewBitmap()
    End Sub

    ' Tworzy nowy pusty obraz.
    Private Sub mnuFileClear_Click() Handles mnuFileClear.Click
        MakeNewBitmap()
    End Sub

    ' Tworzy nowy obiekt Bitmap odpowiadający obszarowi roboczemu.
    Private Sub MakeNewBitmap()
        ' Pobiera rozmiar powierzchni rysowniczej.
        Dim wid As Integer = picCanvas.ClientSize.Width
        Dim hgt As Integer = picCanvas.ClientSize.Height

        ' Dostosowuje obiekty Bitmap i Graphics.
        m_Bitmap = New Bitmap(wid, hgt)
        m_Graphics = Graphics.FromImage(m_Bitmap)

        ' Czyści obszar rysowniczy.
        m_Graphics.Clear(Me.BackColor)

        ' Wyświetla wynik.
        picCanvas.Image = m_Bitmap
    End Sub

    ' Początek gryzmolenia.
    Private Sub picCanvas_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles picCanvas.MouseDown
        m_Drawing = True
        m_X = e.X
        m_Y = e.Y
    End Sub

    ' Kontynuacja gryzmolenia.
    Private Sub picCanvas_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles picCanvas.MouseMove
        If Not m_Drawing Then Exit Sub

        m_Graphics.DrawLine(Pens.Black, m_X, m_Y, e.X, e.Y)
        m_X = e.X
        m_Y = e.Y

        ' Wyświetlenie wyniku.
        picCanvas.Refresh()
    End Sub

    ' Koniec gryzmolenia.
    Private Sub picCanvas_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles picCanvas.MouseUp
        m_Drawing = False
    End Sub
End Class
