﻿Imports System.Runtime.InteropServices

Module UacStuff
    Declare Auto Function SendMessage Lib "user32.dll" _
        (ByVal hWnd As HandleRef, ByVal msg As Int32, _
        ByVal wParam As IntPtr, ByVal lParam As IntPtr) As Int32

    ' Sprawia, że przycisk wyświetla tarczę.
    Public Sub AddShieldToButton(ByVal btn As Button)
        Const BCM_SETSHIELD As Int32 = &H160C

        btn.FlatStyle = Windows.Forms.FlatStyle.System
        SendMessage(New HandleRef(btn, btn.Handle), _
            BCM_SETSHIELD, IntPtr.Zero, CType(1, IntPtr))
    End Sub

    ' Zwraca mapę bitową zawierającą tarczę.
    Public Function GetUacShieldImage() As Bitmap
        Static shield_bm As Bitmap = Nothing
        If shield_bm Is Nothing Then
            Const WID As Integer = 50
            Const HGT As Integer = 50
            Const MARGIN As Integer = 4

            ' Tworzy przycisk.
            Dim btn As New Button
            btn.Text = " "
            btn.Size = New System.Drawing.Size(WID, HGT)
            AddShieldToButton(btn)

            ' Rysowanie przycisku na mapie bitowej.
            Dim bm As New Bitmap(WID, HGT)
            btn.Refresh()
            btn.DrawToBitmap(bm, New Rectangle(0, 0, WID, HGT))

            ' Znajduje część zawierającą tarczę.
            Dim min_x As Integer = WID
            Dim max_x As Integer = 0
            Dim min_y As Integer = WID
            Dim max_y As Integer = 0

            ' Wypełnienie po lewej.
            For y As Integer = MARGIN To HGT - MARGIN - 1
                ' Sprawdza kolor lewego piksela.
                Dim target_color As Color = bm.GetPixel(MARGIN, y)

                ' Wypełnia tym kolorem dopóki widać cel.
                For x As Integer = MARGIN To WID - MARGIN - 1
                    ' Sprawdza czy piksel należy do tarczy.
                    If bm.GetPixel(x, y).Equals(target_color) Then
                        ' Nie należy do tarczy.
                        ' Czyści piksel.
                        bm.SetPixel(x, y, Color.Transparent)
                    Else
                        ' Należy do tarczy.
                        If min_y > y Then min_y = y
                        If min_x > x Then min_x = x
                        If max_y < y Then max_y = y
                        If max_x < x Then max_x = x
                    End If
                Next x
            Next y

            ' Odcina część z tarczą.
            Dim shield_wid As Integer = max_x - min_x + 1
            Dim shield_hgt As Integer = max_y - min_y + 1
            shield_bm = New Bitmap(shield_wid, shield_hgt)
            Dim shield_gr As Graphics = Graphics.FromImage(shield_bm)
            shield_gr.DrawImage(bm, 0, 0, _
                New Rectangle(min_x, min_y, shield_wid, shield_hgt), _
                GraphicsUnit.Pixel)
        End If

        Return shield_bm
    End Function
End Module
