﻿Public Class Form1
    Private Sub frmDragRichText_Load() Handles MyBase.Load
        ' Wstawienie tekstu do pola RichTextBox.
        Dim txt As String = "Mężny bądź, chroń pułk twój i sześć flag."
        rchSource.Text = txt

        rchSource.Select(txt.IndexOf("Mężny"), Len("Mężny"))
        rchSource.SelectionFont = New Font(rchSource.SelectionFont, FontStyle.Italic)

        rchSource.Select(txt.IndexOf("bądź"), Len("bądź"))
        rchSource.SelectionFont = New Font(rchSource.SelectionFont, FontStyle.Bold)
        rchSource.SelectionColor = Color.Brown

        rchSource.Select(txt.IndexOf("chroń"), Len("chroń"))
        rchSource.SelectionFont = New Font(rchSource.SelectionFont, FontStyle.Bold)
        rchSource.SelectionColor = Color.Red

        rchSource.Select(txt.IndexOf("pułk twój"), Len("pułk twój"))
        rchSource.SelectionFont = New Font(rchSource.SelectionFont, FontStyle.Underline)

        rchSource.Select(txt.IndexOf("i sześć"), Len("i sześć"))
        rchSource.SelectionFont = New Font(rchSource.SelectionFont, FontStyle.Bold)

        rchSource.Select(txt.IndexOf("flag"), Len("flag"))
        rchSource.SelectionFont = New Font(rchSource.SelectionFont, FontStyle.Bold)
        rchSource.SelectionColor = Color.Blue

        rchSource.Select(0, 0)
    End Sub

    ' Początek przeciągania.
    Private Sub lblDragSource_MouseDown() Handles lblDragSource.MouseDown
        ' Utworzenie obiektu DataObject.
        Dim data_object As New DataObject

        ' Dodanie danych w różnych formatach.
        data_object.SetData(DataFormats.Rtf, rchSource.Rtf)
        data_object.SetData(DataFormats.Text, rchSource.Text)

        ' Budowa wersji HTML.
        Dim html_text As String
        html_text = "<HTML>" & vbCrLf
        html_text &= "  <HEAD>Mężny bądź</HEAD>" & vbCrLf
        html_text &= "  <BODY>" & vbCrLf
        html_text &= rchSource.Text & vbCrLf
        html_text &= "  </BODY>" & vbCrLf & "</HTML>"
        data_object.SetData(DataFormats.Html, html_text)

        ' Początek przeciągania.
        lblDragSource.DoDragDrop(data_object, DragDropEffects.Copy)
    End Sub

    ' Zezwala na upuszczanie danych Rtf, Text oraz HTML.
    Private Sub lblDropTarget_DragEnter(ByVal sender As Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles lblDropTarget.DragEnter
        If e.Data.GetDataPresent(DataFormats.Rtf) Or _
           e.Data.GetDataPresent(DataFormats.Text) Or _
           e.Data.GetDataPresent(DataFormats.Html) _
        Then
            e.Effect = DragDropEffects.Copy
        End If
    End Sub

    ' Wyświetlanie co się da.
    Private Sub lblDropTarget_DragDrop(ByVal sender As Object, ByVal e As System.Windows.Forms.DragEventArgs) Handles lblDropTarget.DragDrop
        If e.Data.GetDataPresent(DataFormats.Rtf) Then
            rchTarget.Rtf = e.Data.GetData(DataFormats.Rtf).ToString
            lblRtf.Text = e.Data.GetData(DataFormats.Rtf).ToString
        Else
            rchTarget.Text = ""
            lblRtf.Text = ""
        End If

        If e.Data.GetDataPresent(DataFormats.Text) Then
            lblTarget.Text = e.Data.GetData(DataFormats.Text).ToString
        Else
            lblTarget.Text = ""
        End If

        If e.Data.GetDataPresent(DataFormats.Html) Then
            lblHtml.Text = e.Data.GetData(DataFormats.Html).ToString
        Else
            lblHtml.Text = ""
        End If
    End Sub
End Class
