﻿Option Explicit On
Option Infer Off
Option Strict On

Imports System.Xml

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Tworzenie danych.
        Dim all_customers As New List(Of Customer)
        all_customers.Add(New Customer() With {.FirstName = "Ann", .LastName = "Archer", .Balance = 100D})
        all_customers.Add(New Customer() With {.FirstName = "Ben", .LastName = "Best", .Balance = -24.54D})
        all_customers.Add(New Customer() With {.FirstName = "Carly", .LastName = "Cant", .Balance = 62.4D})
        all_customers.Add(New Customer() With {.FirstName = "Dan", .LastName = "Dump", .Balance = 117.95D})
        all_customers.Add(New Customer() With {.FirstName = "Edna", .LastName = "Ever", .Balance = -192.75D})
        all_customers.Add(New Customer() With {.FirstName = "Frank", .LastName = "Fix", .Balance = -150.9D})

        Dim txt As String = ""

        ' Budowanie hierarchii XmlElement.
        Dim xml_doc As New XmlDocument()
        Dim xml_allcusts As XmlElement = xml_doc.CreateElement("AllCustomers")
        Dim ann_cust As XmlElement = xml_doc.CreateElement("Customer")
        xml_allcusts.AppendChild(ann_cust)
        ann_cust.Attributes.Append( _
            xml_doc.CreateAttribute("FirstName", "Ann"))
        ann_cust.Attributes.Append( _
            xml_doc.CreateAttribute("LastName", "Archer"))
        xml_allcusts.AppendChild( _
            xml_doc.CreateTextNode("100.00"))

        Dim bob_cust As XmlElement = xml_doc.CreateElement("Customer")
        xml_allcusts.AppendChild(bob_cust)
        bob_cust.Attributes.Append( _
            xml_doc.CreateAttribute("FirstName", "Bob"))
        bob_cust.Attributes.Append( _
            xml_doc.CreateAttribute("LastName", "Best"))
        xml_allcusts.AppendChild( _
            xml_doc.CreateTextNode("-24.54"))

        Dim carly_cust As XmlElement = xml_doc.CreateElement("Customer")
        xml_allcusts.AppendChild(carly_cust)
        carly_cust.Attributes.Append( _
            xml_doc.CreateAttribute("FirstName", "Carly"))
        carly_cust.Attributes.Append( _
            xml_doc.CreateAttribute("LastName", "Cant"))
        xml_allcusts.AppendChild( _
            xml_doc.CreateTextNode("62.40"))
        txt &= "XML Hierarchy:" & vbCrLf & xml_allcusts.OuterXml() & vbCrLf & vbCrLf

        ' Budowanie hierarchii XmlElement jawnie.
        Dim x_hierarchy As XElement = _
            <AllCustomers>
                <Customer FirstName="Ann" LastName="Archer">100.00</Customer>
                <Customer FirstName="Ben" LastName="Best">-24.54</Customer>
                <Customer FirstName="Carly" LastName="Cant">62.40</Customer>
            </AllCustomers>
        txt &= "LINQ XML Literal:" & vbCrLf & x_hierarchy.ToString() & vbCrLf & vbCrLf

        ' Wybranie klientów z ujemnymi saldami.
        Dim neg_bal As XElement = _
            <NegativeBalances>
                <%= From cust In all_customers _
                    Where cust.Balance < 0 _
                    Select New XElement("Customer", _
                    New XAttribute("FirstName", cust.FirstName), _
                    New XAttribute("LastName", cust.LastName), _
                    New XText(cust.Balance.ToString("0.00"))) _
                %>
            </NegativeBalances>
        txt &= "Ujemne salda LINQ:" & vbCrLf & neg_bal.ToString() & vbCrLf & vbCrLf

        Dim x_doc As XDocument = _
            <?xml version="1.0" encoding="utf-8"?>
            <!-- Dane klientów -->
            <AllCustomers>
                <Customer FirstName="Ann" LastName="Archer">100.00</Customer>
                <Customer FirstName="Ben" LastName="Best">-24.54</Customer>
                <Customer FirstName="Carly" LastName="Cant">62.40</Customer>
            </AllCustomers>
        txt &= "Literał XDocument LINQ:" & vbCrLf & x_doc.ToString() & vbCrLf & vbCrLf

        Dim neg_doc As XDocument = _
            <?xml version="1.0" encoding="utf-8"?>
            <!-- Klienci z ujemnymi saldami -->
            <NegativeBalances>
                <%= From cust In all_customers _
                    Where cust.Balance < 0 _
                    Select New XElement("Customer", _
                    New XAttribute("FirstName", cust.FirstName), _
                    New XAttribute("LastName", cust.LastName), _
                    New XText(cust.Balance.ToString("0.00"))) _
                %>
            </NegativeBalances>
        txt &= "XDocument LINQ z ujemnymi saldami:" & vbCrLf & neg_doc.ToString() & vbCrLf & vbCrLf

        Dim x_att As XComment = <!-- text -->
        txt &= "Komentarz:" & vbCrLf & x_att.ToString() & vbCrLf & vbCrLf

        Dim x_cdata As XCData = <![CDATA[
Some data.
More data.
The last line.]]>
        txt &= "CDATA:" & vbCrLf & x_cdata.ToString() & vbCrLf & vbCrLf

        Dim x_pi As XProcessingInstruction = <?xml-stylesheet type="text/xsl" href="show_book.xsl"?>
        txt &= "Przetwarzanie instrukcji:" & vbCrLf & x_pi.ToString() & vbCrLf & vbCrLf

        ' Poniższy kod nie działa.
        ' Dim x_attr As XAttribute = ??? I don't even know what this would look like.
        ' Dim x_decl As XDeclaration = <?xml version="1.0" encoding="ISO-8859-1" ?>
        ' Dim x_name As XName = ??? I don't even know what this would look like.
        ' Dim x_text As XText = "Test"

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub
End Class

Public Class Customer
    Public FirstName As String
    Public LastName As String
    Public Balance As Decimal
    Public Overrides Function ToString() As String
        Return FirstName & " " & LastName & " (" & Balance & ")"
    End Function
End Class
