﻿Public Class Form1
    Private Values() As Integer
    Private Const NUM_VALUES As Integer = 99

    ' Generuje i wyświetla losowe liczby z przedziału od 100 do 999.
    Private Sub btnRandomize_Click() Handles btnRandomize.Click
        Dim i As Integer
        Dim txt As String = ""
        Dim random_number As New Random

        ReDim Values(NUM_VALUES)
        For i = 0 To NUM_VALUES
            Values(i) = random_number.Next(100, 1000)
            txt &= Format$(Values(i)) & " "
        Next i
        lblNumbers.Text = txt
    End Sub

    ' Sortowanie liczb.
    Private Sub btnSort_Click() Handles btnSort.Click
        Dim i As Integer
        Dim txt As String = ""

        ' Sort liczb.
        Quicksort(Values, 0, NUM_VALUES)

        ' VWeryfikacja i wyświetlenie wyników.
        txt &= Format$(Values(0)) & " "
        For i = 1 To NUM_VALUES
            If Values(i) < Values(i - 1) Then Stop
            txt = txt & Format$(Values(i)) & " "
        Next i

        lblNumbers.Text = txt
    End Sub
End Class

Module QuickSortRoutines
    ' Quicksort. Szczegóły i inne algorytmy sortujące
    ' działające w innych sytuacjach znajdziesz w książce
    ' "Ready-to-Run Visual Basic Algorithms"
    ' (http://www.vb-helper.com/vba.htm).
    Public Sub Quicksort(ByVal list() As Integer, ByVal min As Integer, ByVal max As Integer)
        Dim random_number As New Random
        Dim med_value As Integer
        Dim hi As Integer
        Dim lo As Integer
        Dim i As Integer

        ' If min >= max, lista zawiera 0 lub 1 element, a więc
        ' jest posortowana.
        If min >= max Then Exit Sub

        ' Pobramie wartości dzielącej.
        i = random_number.Next(min, max + 1)
        med_value = list(i)

        list(i) = list(min)

        lo = min
        hi = max
        Do
            ' Szukanie od hi w dół wartości < med_value.
            Do While list(hi) >= med_value
                hi = hi - 1
                If hi <= lo Then Exit Do
            Loop
            If hi <= lo Then
                list(lo) = med_value
                Exit Do
            End If

            ' Zamiana wartości lo i hi.
            list(lo) = list(hi)

            ' Szukanie od lo w górę wartości >= med_value.
            lo = lo + 1
            Do While list(lo) < med_value
                lo = lo + 1
                If lo >= hi Then Exit Do
            Loop
            If lo >= hi Then
                lo = hi
                list(hi) = med_value
                Exit Do
            End If

            ' Zamiana wartości lo i hi.
            list(hi) = list(lo)
        Loop

        ' Sortowanie dwóch podlist.
        Quicksort(list, min, lo - 1)
        Quicksort(list, lo + 1, max)
    End Sub
End Module