﻿Imports System.IO
Imports System.Reflection
Imports System.Resources

Public Class Form1
    Private m_TargetAssembly As Assembly

    Private Sub Form1_Load() Handles MyBase.Load
        ' Aplikacja docelowa.
        txtFile.Text = My.Computer.FileSystem.CombinePath( _
            Application.StartupPath, _
            "..\..\..\ReflectionHasResources\bin\Release\ReflectionHasResources.dll")
        txtFile.Select(0, 0)
    End Sub

    ' Lista zasobów docelowej asemblacji.
    Private Sub btnList_Click() Handles btnList.Click
        ' Get the target assembly.
        m_TargetAssembly = Assembly.LoadFile(txtFile.Text)

        ' Lista nazw zasobów manifestu celu.
        lstResourceFiles.Items.Clear()
        For Each str As String In m_TargetAssembly.GetManifestResourceNames()
            lstResourceFiles.Items.Add(str)
        Next str
    End Sub

    ' Lista zasobów pliku.
    Private Sub lstResourceFiles_SelectedIndexChanged() Handles lstResourceFiles.SelectedIndexChanged
        If lstResourceFiles.SelectedIndex < 0 Then Exit Sub

        lstResources.Items.Clear()

        Dim resource_reader As New ResourceReader( _
            m_TargetAssembly.GetManifestResourceStream(lstResourceFiles.Text))
        Dim dict_enumerator As IDictionaryEnumerator = resource_reader.GetEnumerator()
        While dict_enumerator.MoveNext()
            lstResources.Items.Add(New ResourceInfo( _
                dict_enumerator.Key, _
                dict_enumerator.Value))
        End While
        resource_reader.Close()
    End Sub

    ' Wyświetla wybrane zasoby.
    Private Sub lstResources_SelectedIndexChanged() Handles lstResources.SelectedIndexChanged
        lblString.Text = ""
        picImage.Image = Nothing
        Me.Cursor = Cursors.WaitCursor
        Refresh()

        Dim resource_info As ResourceInfo = _
            DirectCast(lstResources.SelectedItem, ResourceInfo)
        Select Case resource_info.Value.GetType.Name
            Case "Bitmap"
                picImage.Image = CType(resource_info.Value, Bitmap)
            Case "String"
                lblString.Text = CType(resource_info.Value, String)
            Case Else
                ' Próba odtworzenia jako dźwięku.
                Try
                    My.Computer.Audio.Play(resource_info.Value, AudioPlayMode.WaitToComplete)
                Catch ex As Exception
                    MessageBox.Show(resource_info.Key & " ma nieznany typ zasobów", "Nieznany typ zasobów", MessageBoxButtons.OK)
                End Try
        End Select

        Me.Cursor = Cursors.Default
    End Sub

    Private Class ResourceInfo
        Public Key As Object
        Public Value As Object
        Public Sub New(ByVal new_key As Object, ByVal new_value As Object)
            Key = new_key
            Value = new_value
        End Sub
        Public Overrides Function ToString() As String
            Return Key.ToString & " (" & Value.ToString & ")"
        End Function
    End Class
End Class
