﻿Public Class Form1
    Private m_Target As EnvironmentVariableTarget = EnvironmentVariableTarget.Process

    ' Pobiera wartość zmiennej środowiskowej.
    Private Sub btnGet_Click() Handles btnGet.Click
        txtVariableValue.Text = System.Environment.GetEnvironmentVariable( _
            txtVariableName.Text, m_Target)
    End Sub

    ' ustawia wartość.
    Private Sub btnSet_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSet.Click
        Try
            System.Environment.SetEnvironmentVariable( _
                txtVariableName.Text, txtVariableValue.Text, m_Target)
        Catch ex As Exception
            MessageBox.Show(ex.Message, "Error", _
                MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub

    ' Śledzi pożądany poziom.
    Private Sub rad_CheckedChanged() Handles radSystem.CheckedChanged, radUser.CheckedChanged, radProcess.CheckedChanged
        If radSystem.Checked Then
            m_Target = EnvironmentVariableTarget.Machine
        ElseIf radUser.Checked Then
            m_Target = EnvironmentVariableTarget.User
        Else
            m_Target = EnvironmentVariableTarget.Process
        End If
    End Sub
End Class
