﻿Public Class Form1
    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Me.SetStyle(ControlStyles.AllPaintingInWmPaint Or ControlStyles.ResizeRedraw, True)
        Me.UpdateStyles()
    End Sub
    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        DrawSamples(e.Graphics)
    End Sub

    Private Sub DrawSamples(ByVal gr As Graphics)
        ' Tworzy tablicę wszystkich wartości HatchStyle.
        Dim styles As Array = _
            Drawing2D.HatchStyle.GetValues(GetType(Drawing2D.HatchStyle))

        ' Rysuje przykłady wszystkich stylów.
        Dim x As Integer = 10
        Dim y As Integer = 20
        gr.Clear(Me.BackColor)
        For Each hatch_style As Drawing2D.HatchStyle In styles
            DrawSample(gr, x, y, hatch_style)
        Next hatch_style
    End Sub

    Private Sub DrawSample(ByVal gr As Graphics, ByRef x As Integer, ByRef y As Integer, ByVal hatch_style As Drawing2D.HatchStyle)
        gr.DrawString(hatch_style.ToString, Me.Font, Brushes.Black, x, y)
        Using the_brush As New Drawing2D.HatchBrush(hatch_style, Color.Black, Color.White)
            gr.FillRectangle(the_brush, x, y + 15, 100, 20)
        End Using

        y += 40
        If y + 40 > Me.ClientRectangle.Height Then
            x += 150
            y = 20
        End If
    End Sub
End Class
