﻿<ToolboxBitmap(GetType(ColorScroller), "ColorScrollerTool.bmp")> _
Public Class ColorScroller

    ' Informuje program o zmianie koloru.
    Public Event ColorChanged(ByVal new_color As Color)

    ' Pobiera lub ustawia aktualnie wybrany kolor.
    Public Property SelectedColor() As Color
        Get
            Return Color.FromArgb( _
                255, _
                hbarRed.Value, _
                hbarGreen.Value, _
                hbarBlue.Value)
        End Get
        Set(ByVal value As Color)
            Red = value.R
            Green = value.G
            Blue = value.B
        End Set
    End Property

    ' Get: Zwraca wartość komponentu koloru.
    ' Set: Ustawia wartość na pasku przewijania,
    '      wyświetla kolor i zgłasza 
    '      zdarzenie ColorChanged.
    Public Property Red() As Byte
        Get
            Return CByte(hbarRed.Value)
        End Get
        Set(ByVal Value As Byte)
            hbarRed.Value = Value
            lblRed.Text = hbarRed.Value.ToString
            panSample.BackColor = SelectedColor
            RaiseEvent ColorChanged(SelectedColor)
        End Set
    End Property

    Public Property Green() As Byte
        Get
            Return CByte(hbarGreen.Value)
        End Get
        Set(ByVal Value As Byte)
            hbarGreen.Value = Value
            lblGreen.Text = hbarGreen.Value.ToString
            panSample.BackColor = SelectedColor
            RaiseEvent ColorChanged(SelectedColor)
        End Set
    End Property

    Public Property Blue() As Byte
        Get
            Return CByte(hbarBlue.Value)
        End Get
        Set(ByVal Value As Byte)
            hbarBlue.Value = Value
            lblBlue.Text = hbarBlue.Value.ToString
            panSample.BackColor = SelectedColor
            RaiseEvent ColorChanged(SelectedColor)
        End Set
    End Property

    ' Użytkownik zmienił wartość koloru.
    ' Ustawia odpowiednią wartość komponentu koloru.
    Private Sub hbarRed_Scroll() Handles hbarRed.Scroll
        Red = CByte(hbarRed.Value)
    End Sub
    Private Sub hbarGreen_Scroll() Handles hbarGreen.Scroll
        Green = CByte(hbarGreen.Value)
    End Sub
    Private Sub hbarBlue_Scroll() Handles hbarBlue.Scroll
        Blue = CByte(hbarBlue.Value)
    End Sub
End Class
