﻿Partial Public Class WizardPage1
    Inherits PageFunction(Of WizardData)

    Private m_WizardData As WizardData
    Private WithEvents m_Page2 As WizardPage2

    ' Zapisanie obiektu WizardData.
    Public Sub New(ByVal wizard_data As WizardData)
        InitializeComponent()

        m_WizardData = wizard_data
    End Sub

    ' Kolejna strona zwraca wynik.
    Private Sub m_Page2_Return(ByVal sender As Object, ByVal e As System.Windows.Navigation.ReturnEventArgs(Of WizardData)) Handles m_Page2.Return
        OnReturn(e)
    End Sub

#Region "Navigation"
    ' Otwarcie następnej strony.
    Public Sub btnNext_Click() Handles btnNext.Click
        If NavigationService.CanGoForward Then
            NavigationService.GoForward()
        Else
            m_Page2 = New WizardPage2(m_WizardData)
            NavigationService.Navigate(m_Page2)
        End If
    End Sub

    ' Zwrócenie wyniku oznaczającego, że użytkownik nacisnął przycisk anulowania.
    Private Sub btnCancel_Click() Handles btnCancel.Click
        m_WizardData.Canceled = True
        OnReturn(New ReturnEventArgs(Of WizardData)(m_WizardData))
    End Sub
#End Region ' Nawigacja

#Region "Zapisywanie wyborów użytkownika"
    ' Zapisanie wyboru użytkownika.
    Private Sub cboAppetizer_SelectionChanged() Handles cboAppetizer.SelectionChanged
        ' Własność Text listy nie jest jeszcze zaktualizowana.
        If cboAppetizer.SelectedIndex < 0 Then
            m_WizardData.Appetizer = ""
        Else
            m_WizardData.Appetizer = cboAppetizer.Items(cboAppetizer.SelectedIndex).Content
        End If
    End Sub

    ' Zapisanie wyboru.
    Private Sub chkSalad_Checked() Handles chkSalad.Checked, chkSalad.Unchecked
        m_WizardData.Salad = chkSalad.IsChecked
    End Sub
#End Region ' Zapisywanie wyborów

End Class

