﻿'Imports System
Imports System.Security.Permissions

<Assembly: EventLogPermission( _
    SecurityAction.RequestMinimum, _
    PermissionAccess:=EventLogPermissionAccess.Administer)> 

Public Class Form1
    ' Łączy z dziennikiem.
    Private Sub Form1_Load(ByVal sender As System.Object, _
     ByVal e As System.EventArgs) Handles MyBase.Load
        ' Założenie, że aby zapisywać w dzienniku zdarzeń trzeba mieć uprawnienia.
        Dim log_permission As New EventLogPermission( _
                EventLogPermissionAccess.Administer, ".")
        Try
            log_permission.Assert()
            log_permission.Demand()
            log_permission.PermitOnly()
        Catch ex As Exception
            MessageBox.Show("Ten użytkownik nie ma uprawnień, aby zapisywać w dzienniku.", "Brak uprawnień", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Me.Close()
            Exit Sub
        End Try

        ' Sprawdza czy dziennik istnieje i tworzy go, jeśli nie.
        If Not EventLog.SourceExists("StatusSource") Then
            EventLog.CreateEventSource("StatusSource", "StatusLog")
            Debug.WriteLine("Tworzenie źródła zdarzeń")
        End If

        ' Ustawia źródło komponentu EventLog.
        logStatus.Source = "StatusSource"

        ' Zapisuje w dzienniku komunikat Zaczynanie.
        logStatus.WriteEntry(Now & "> " & "Zaczynanie", _
            EventLogEntryType.Information)
        ShowLog()
    End Sub

    ' Zapisuje komunikat o zamykaniu w dzienniku.
    Private Sub Form1_FormClosing(ByVal sender As Object, _
     ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        ''logStatus.WriteEntry(Now & "> " & "Closing", _
        ''    EventLogEntryType.Information)
    End Sub

    ' Dodaje wpis do dziennika.
    Private Sub btnAddToLog_Click(ByVal sender As System.Object, _
     ByVal e As System.EventArgs) Handles btnAddToLog.Click

    End Sub

    ' Włącza lub wyłącza btnAddToLog.
    Private Sub txtMessage_TextChanged(ByVal sender As System.Object, _
     ByVal e As System.EventArgs) Handles txtMessage.TextChanged
        btnAddToLog.Enabled = (txtMessage.Text.Length > 0)
    End Sub

    ' Czyści dziennik.
    Private Sub btnClearLog_Click(ByVal sender As System.Object, _
     ByVal e As System.EventArgs) Handles btnClearLog.Click
        logStatus.Clear()
        ShowLog()
    End Sub

    ' Lista elementów dziennika.
    Private Sub ShowLog()
        lstLog.Items.Clear()

        For Each log_entry As EventLogEntry In logStatus.Entries
            lstLog.Items.Add(log_entry.Message)
        Next log_entry
        lstLog.SelectedIndex = lstLog.Items.Count - 1
    End Sub

    Private Sub lstLog_DoubleClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstLog.DoubleClick
        Debug.WriteLine(lstLog.SelectedItem.ToString)
    End Sub
End Class
