﻿Imports System.Drawing.Imaging
Imports System.Drawing.Drawing2D

Public Class Form1
    ' Rysuje początkowy obraz.
    Private Sub Form1_Load() Handles MyBase.Load
        DrawDiamond()
    End Sub

    ' Rysuje obraz w nowych wymiarach.
    Private Sub Form1_Resize() Handles MyBase.Resize
        DrawDiamond()
    End Sub

    Private Sub DrawDiamond()
        ' Pobiera obszar powierzchni rysunkowej.
        Dim wid As Integer = picCanvas.ClientSize.Width
        Dim hgt As Integer = picCanvas.ClientSize.Height

        ' Nic nie robi, jeśli nie ma podanego rozmiaru.
        ' Ma to miejsce na przykład wówczas, gdy formularz zostanie zminimalizowany.
        If wid < 1 Or hgt < 1 Then Exit Sub

        Dim bm As New Bitmap(wid, hgt)
        Using gr As Graphics = Graphics.FromImage(bm)
            ' Wypełnia obszar do rysowania wzorem kreskowanym.
            Using bg_brush As New HatchBrush(HatchStyle.HorizontalBrick, _
                Color.Blue, Color.Aqua)
                gr.FillRectangle(bg_brush, picCanvas.ClientRectangle)
            End Using ' bg_brush

            ' Rysuje romb.
            Dim pts() As Point = { _
                New Point(wid \ 2, 0), _
                New Point(wid, hgt \ 2), _
                New Point(wid \ 2, hgt), _
                New Point(0, hgt \ 2) _
            }
            gr.FillPolygon(Brushes.White, pts)
            gr.DrawPolygon(Pens.Black, pts)

            ' Wyświetla wynik.
            picCanvas.Image = bm
        End Using ' gr
    End Sub
End Class
